document.addEventListener("DOMContentLoaded", function () {

	// Funkcija, kas sagatavo un apstrādā lapā esošos moduļus
    function setupModalHandlers() {
        const modalButtons = {
            'login-btn': 'login-modal',
            'register-btn': 'register-modal'
        };

        Object.entries(modalButtons).forEach(([buttonId, modalId]) => {
            const btn = document.getElementById(buttonId);
            const modal = document.getElementById(modalId);

            if (btn && modal) {
                btn.addEventListener('click', () => {
                    modal.style.display = 'block';
                });
            }
        });

        document.querySelectorAll('.close').forEach(closeBtn => {
            closeBtn.addEventListener('click', (e) => {
                const modal = e.target.closest('.modal');
                if (modal) modal.style.display = 'none';
            });
        });

        window.addEventListener('click', (e) => {
            if (e.target.classList.contains('modal')) {
                e.target.style.display = 'none';
            }
        });
    }

    setupModalHandlers();

    // Pieslēgšanās formas apstrāde (datu nosūtīšana PHP failam)
    const loginForm = document.getElementById("login-form");
    if (loginForm) {
        loginForm.addEventListener("submit", function (e) {
            e.preventDefault();

            const username = document.getElementById("login-user").value.trim();
            const passw = document.getElementById("login-passw").value;

            const formData = new FormData();
            formData.append("username", username);
            formData.append("password", passw);

            fetch("php/login.php", {
                method: "POST",
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if (data.id) {
                    localStorage.setItem('userId', data.id);
                    alert("Login successful!");
					window.location.href = "calendar.html";
                } else if (data.error) {
                    alert(data.error);
                } else {
                    alert("Unexpected server response.");
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Login failed. Check console for details.");
            });
        });
    }

    // Reģistrācijas formas apstrāde (datu nosūtīšana PHP failam)
    const registerForm = document.getElementById("register-form");
    if (registerForm) {
        registerForm.addEventListener("submit", function (e) {
            e.preventDefault();

            const username = document.getElementById("register-user").value.trim();
            const email = document.getElementById("email").value.trim();
            const passw = document.getElementById("register-passw").value;
            const confirmPassword = document.getElementById("register-confirm-passw").value;

            if (passw !== confirmPassword) {
                alert("Passwords do not match.");
                return;
            }

            const formData = new FormData();
            formData.append("username", username);
            formData.append("email", email);
            formData.append("password", passw);

            sendFormData("php/register.php", formData);
        });
    }

	// Funkcija, kas darbojas kā palīgs datu nosūtīšanai uz PHP failiem
    function sendFormData(url, formData) {
        fetch(url, {
            method: "POST",
            body: formData
        })
        .then(res => res.text())
        .then(data => {
            alert(data);
            console.log("Server says:", data);
        })
        .catch(error => {
            console.error("Error:", error);
            alert("Something went wrong. Check console for details.");
        });
    }

});
