-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for darbu_planotajs
CREATE DATABASE IF NOT EXISTS `darbu_planotajs` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `darbu_planotajs`;

-- Dumping structure for table darbu_planotajs.calendars
CREATE TABLE IF NOT EXISTS `calendars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `color` varchar(7) DEFAULT '#000000',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `calendars_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table darbu_planotajs.calendars: ~3 rows (approximately)
INSERT INTO `calendars` (`id`, `user_id`, `name`, `color`, `created_at`) VALUES
	(1, 1, 'test red', '#ff0000', '2025-03-10 12:15:17'),
	(2, 3, 'Kalendars', '#000000', '2025-03-10 12:37:48'),
	(3, 3, 'Kalendars darbam', '#00ff33', '2025-03-10 12:50:36'),
	(4, 1, 'Kalendars darbam', '#fff700', '2025-03-12 08:08:07'),
	(5, 5, 'Darbam', '#ff0000', '2025-06-09 07:05:08');

-- Dumping structure for table darbu_planotajs.calendar_shares
CREATE TABLE IF NOT EXISTS `calendar_shares` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `calendar_id` int(11) NOT NULL,
  `shared_with_user_id` int(11) NOT NULL,
  `can_edit` tinyint(1) DEFAULT 0,
  `is_approved` tinyint(1) DEFAULT 0,
  `shared_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`),
  KEY `shared_with_user_id` (`shared_with_user_id`),
  CONSTRAINT `calendar_shares_ibfk_1` FOREIGN KEY (`calendar_id`) REFERENCES `calendars` (`id`) ON DELETE CASCADE,
  CONSTRAINT `calendar_shares_ibfk_2` FOREIGN KEY (`shared_with_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table darbu_planotajs.calendar_shares: ~1 rows (approximately)
INSERT INTO `calendar_shares` (`id`, `calendar_id`, `shared_with_user_id`, `can_edit`, `is_approved`, `shared_at`) VALUES
	(1, 1, 1, 0, 0, '2025-03-10 12:16:39');

-- Dumping structure for table darbu_planotajs.tasks
CREATE TABLE IF NOT EXISTS `tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `calendar_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`),
  CONSTRAINT `tasks_ibfk_1` FOREIGN KEY (`calendar_id`) REFERENCES `calendars` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table darbu_planotajs.tasks: ~4 rows (approximately)
INSERT INTO `tasks` (`id`, `calendar_id`, `title`, `description`, `start_time`, `end_time`, `created_at`) VALUES
	(3, 2, 'test', 'test', '2025-03-10 02:22:00', '2025-03-25 02:22:00', '2025-03-10 12:38:33'),
	(5, 3, 'asdfas', 'ffdsaf', '2025-03-10 12:00:00', '2025-03-11 12:00:00', '2025-03-10 12:53:03'),
	(6, 3, 'adghsdag', 'agasdgasd', '2025-03-12 12:00:00', '2025-03-22 12:00:00', '2025-03-10 12:53:13'),
	(8, 5, 'Izpildit darba planotaju', '', '2025-06-09 12:00:00', '2025-06-10 12:00:00', '2025-06-09 07:05:34');

-- Dumping structure for table darbu_planotajs.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table darbu_planotajs.users: ~4 rows (approximately)
INSERT INTO `users` (`id`, `username`, `email`, `password_hash`, `created_at`) VALUES
	(1, 'test', 'test22@gmail.com', '$2y$10$XfnVOaeyvaYUFejLBe.oAeHqo7seQZLI5d0Fm.4CUyZx9FD6867qC', '2025-03-06 12:08:36'),
	(2, 'test1', 'test12@gmail.com', '$2y$10$W6sSJbyHUDvo9gT12lRH0ur6y1q3Hi1ftFDD2iVbAzcI/RkaZLZga', '2025-03-10 12:20:14'),
	(3, 'Daniils', 'daniils@gmail.com', '$2y$10$rYPwqQMI/1Bwhv9GPzh6ue3UuAy0.5UZ76hiw6p8wQJslTXxdRl3a', '2025-03-10 12:36:25'),
	(4, 'Nikita', 'nikita@gmail.com', '$2y$10$2so6b/uG3Nia8d2HIvpUe.d2ZzQyhTXxZ0DIkZzBa.EE8CuYw4fr6', '2025-03-10 12:40:40'),
	(5, 'admin', 'test@gmail.com', '$2y$10$leNx7iQpopzhDPNURM/FCOHDBMhr6bF9Q/NFg1tcg5aMh6Gq9qwA6', '2025-06-09 07:04:44');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
