import type { NextServer, RequestHandler, UpgradeHandler } from 'next/dist/server/next';
import type { DevBundlerService } from 'next/dist/server/lib/dev-bundler-service';
import type { PropagateToWorkersField } from 'next/dist/server/lib/router-utils/types';
import type { Span } from 'next/dist/trace';
export type ServerInitResult = {
    requestHandler: RequestHandler;
    upgradeHandler: UpgradeHandler;
    server: NextServer;
    closeUpgraded: () => void;
};
export declare function clearAllModuleContexts(): Promise<void> | undefined;
export declare function clearModuleContext(target: string): Promise<void> | undefined;
export declare function getServerField(dir: string, field: PropagateToWorkersField): Promise<string | number | import("next/dist/server/route-matcher-managers/route-matcher-manager").RouteMatcherManager | ((prefix?: string) => void) | (() => Promise<void>) | ((err: Error) => void) | (() => import("next/dist/server/next-server").NodeRequestHandler) | (() => Promise<void>) | ((req: import("next/dist/server/base-http/node").NodeNextRequest | import("http").IncomingMessage, res: import("next/dist/server/base-http/node").NodeNextResponse | import("http").ServerResponse, pathname: string, query?: import("next/dist/server/request-meta").NextParsedUrlQuery, parsedUrl?: import("next/dist/server/request-meta").NextUrlWithParsedQuery, internal?: boolean) => Promise<void>) | ((req: import("next/dist/server/base-http/node").NodeNextRequest | import("http").IncomingMessage, res: import("next/dist/server/base-http/node").NodeNextResponse | import("http").ServerResponse, pathname: string, query?: import("querystring").ParsedUrlQuery) => Promise<string | null>) | ((err: Error | null, req: import("next/dist/server/base-http/node").NodeNextRequest | import("http").IncomingMessage, res: import("next/dist/server/base-http/node").NodeNextResponse | import("http").ServerResponse, pathname: string, query?: import("next/dist/server/request-meta").NextParsedUrlQuery, setHeaders?: boolean) => Promise<void>) | ((err: Error | null, req: import("next/dist/server/base-http/node").NodeNextRequest | import("http").IncomingMessage, res: import("next/dist/server/base-http/node").NodeNextResponse | import("http").ServerResponse, pathname: string, query?: import("querystring").ParsedUrlQuery) => Promise<string | null>) | ((req: import("next/dist/server/base-http/node").NodeNextRequest | import("http").IncomingMessage, res: import("next/dist/server/base-http/node").NodeNextResponse | import("http").ServerResponse, parsedUrl?: import("next/dist/server/request-meta").NextUrlWithParsedQuery, setHeaders?: boolean) => Promise<void>) | (() => Promise<void>) | ((req: import("next/dist/server/base-http/node").NodeNextRequest, res: import("next/dist/server/base-http/node").NodeNextResponse, parsedUrl?: import("next/dist/server/request-meta").NextUrlWithParsedQuery) => Promise<void>) | (({ urlPath, revalidateHeaders, opts, }: {
    urlPath: string;
    revalidateHeaders: {
        [key: string]: string | string[];
    };
    opts: {
        unstable_onlyGenerated?: boolean;
    };
}) => Promise<void>) | ((meta: import("next/dist/server/request-meta").RequestMeta) => import("next/dist/server/base-server").BaseRequestHandler<import("next/dist/server/base-http/node").NodeNextRequest, import("next/dist/server/base-http/node").NodeNextResponse>) | undefined>;
export declare function propagateServerField(dir: string, field: PropagateToWorkersField, value: any): Promise<void>;
declare function initializeImpl(opts: {
    dir: string;
    port: number;
    dev: boolean;
    minimalMode?: boolean;
    hostname?: string;
    keepAliveTimeout?: number;
    serverFields?: any;
    server?: any;
    experimentalTestProxy: boolean;
    experimentalHttpsServer: boolean;
    _ipcPort?: string;
    _ipcKey?: string;
    bundlerService: DevBundlerService | undefined;
    startServerSpan: Span | undefined;
    quiet?: boolean;
    onDevServerCleanup: ((listener: () => Promise<void>) => void) | undefined;
}): Promise<ServerInitResult>;
export declare function initialize(opts: Parameters<typeof initializeImpl>[0]): Promise<ServerInitResult>;
export {};
