import React from 'react';
import type { GetDynamicParamFromSegment } from 'next/dist/server/app-render/app-render';
import type { LoaderTree } from 'next/dist/server/lib/app-dir-module';
import type { SearchParams } from 'next/dist/server/request/search-params';
import { type MetadataErrorType } from 'next/dist/lib/metadata/resolve-metadata';
import type { MetadataContext } from 'next/dist/lib/metadata/types/resolvers';
import type { WorkStore } from 'next/dist/server/app-render/work-async-storage.external';
export declare function createMetadataComponents({ tree, parsedQuery, metadataContext, getDynamicParamFromSegment, appUsingSizeAdjustment, errorType, workStore, MetadataBoundary, ViewportBoundary, serveStreamingMetadata, }: {
    tree: LoaderTree;
    parsedQuery: SearchParams;
    metadataContext: MetadataContext;
    getDynamicParamFromSegment: GetDynamicParamFromSegment;
    appUsingSizeAdjustment: boolean;
    errorType?: MetadataErrorType | 'redirect';
    workStore: WorkStore;
    MetadataBoundary: (props: {
        children: React.ReactNode;
    }) => React.ReactNode;
    ViewportBoundary: (props: {
        children: React.ReactNode;
    }) => React.ReactNode;
    serveStreamingMetadata: boolean;
}): {
    MetadataTree: React.ComponentType;
    ViewportTree: React.ComponentType;
    getMetadataReady: () => Promise<void>;
    getViewportReady: () => Promise<void>;
    StreamingMetadataOutlet: React.ComponentType;
};
