import type { LoadComponentsReturnType } from 'next/dist/server/load-components';
import type { Params } from 'next/dist/server/request/params';
import type { AppPageModule } from 'next/dist/server/route-modules/app-page/module.compiled';
import type { AppRouteModule } from 'next/dist/server/route-modules/app-route/module.compiled';
import { type AppSegmentConfig } from 'next/dist/build/segment-config/app/app-segment-config';
type GenerateStaticParams = (options: {
    params?: Params;
}) => Promise<Params[]>;
export type AppSegment = {
    name: string;
    param: string | undefined;
    filePath: string | undefined;
    config: AppSegmentConfig | undefined;
    isDynamicSegment: boolean;
    generateStaticParams: GenerateStaticParams | undefined;
};
/**
 * Collects the segments for a given route module.
 *
 * @param components the loaded components
 * @returns the segments for the route module
 */
export declare function collectSegments({ routeModule, }: LoadComponentsReturnType<AppPageModule | AppRouteModule>): Promise<AppSegment[]> | AppSegment[];
export {};
