import React from 'react';
export interface Colors {
    dark?: string;
    light?: string;
}
export interface QRCodeOptions {
    type?: string;
    quality?: number;
    errorCorrectionLevel?: string;
    margin?: number;
    scale?: number;
    width?: number;
    color?: Colors;
}
export interface LogoOptions {
    width?: number;
    x?: number;
    y?: number;
}
export interface Logo {
    src: string;
    options?: LogoOptions;
}
export interface IQRCode {
    text: string;
    options?: QRCodeOptions;
    logo?: Logo;
}
export declare function useQRCode(): {
    Image: <T extends HTMLImageElement>({ text, options, }: IQRCode) => React.JSX.Element;
    Canvas: <T_1 extends HTMLCanvasElement>({ text, options, logo, }: IQRCode) => React.JSX.Element;
    SVG: <T_2 extends HTMLDivElement>({ text, options, }: IQRCode) => React.JSX.Element;
};
