import type { Locale } from 'use-intl';
import type { DomainConfig, DomainsConfig, LocalePrefixConfigVerbose, LocalePrefixMode, Locales, Pathnames } from '../routing/types.js';
export declare function getFirstPathnameSegment(pathname: string): string;
export declare function getInternalTemplate<AppLocales extends Locales, AppPathnames extends Pathnames<AppLocales>>(pathnames: AppPathnames, pathname: string, locale: AppLocales[number]): [AppLocales[number] | undefined, keyof AppPathnames | undefined];
export declare function formatTemplatePathname(sourcePathname: string, sourceTemplate: string, targetTemplate: string, prefix?: string): string;
/**
 * Removes potential prefixes from the pathname.
 */
export declare function getNormalizedPathname<AppLocales extends Locales, AppLocalePrefixMode extends LocalePrefixMode>(pathname: string, locales: AppLocales, localePrefix: LocalePrefixConfigVerbose<AppLocales, AppLocalePrefixMode>): string;
export declare function findCaseInsensitiveString(candidate: string, strings: Array<string>): string | undefined;
export declare function getLocalePrefixes<AppLocales extends Locales, AppLocalePrefixMode extends LocalePrefixMode>(locales: AppLocales, localePrefix: LocalePrefixConfigVerbose<AppLocales, AppLocalePrefixMode>, sort?: boolean): Array<[AppLocales[number], string]>;
export declare function getPathnameMatch<AppLocales extends Locales, AppLocalePrefixMode extends LocalePrefixMode>(pathname: string, locales: AppLocales, localePrefix: LocalePrefixConfigVerbose<AppLocales, AppLocalePrefixMode>, domain?: DomainConfig<AppLocales>): {
    locale: AppLocales[number];
    prefix: string;
    matchedPrefix: string;
    exact?: boolean;
} | undefined;
export declare function getRouteParams(template: string, pathname: string): Record<string, string> | undefined;
export declare function formatPathnameTemplate(template: string, params?: object): string;
export declare function formatPathname(pathname: string, prefix: string | undefined, search: string | undefined): string;
export declare function getHost(requestHeaders: Headers): string | undefined;
export declare function isLocaleSupportedOnDomain<AppLocales extends Locales>(locale: Locale, domain: DomainConfig<AppLocales>): boolean;
export declare function getBestMatchingDomain<AppLocales extends Locales>(curHostDomain: DomainConfig<AppLocales> | undefined, locale: Locale, domainsConfig: DomainsConfig<AppLocales>): DomainConfig<AppLocales> | undefined;
export declare function applyBasePath(pathname: string, basePath: string): string;
export declare function getLocaleAsPrefix<AppLocales extends Locales>(locale: AppLocales[number]): string;
export declare function sanitizePathname(pathname: string): string;
