import { NextRequest, NextResponse } from "next/server";
import jwt from "jsonwebtoken";
import prisma from "@/lib/prisma";

export const auth = async (req: NextRequest) => {
    try {
        const refresh_token = req.cookies.get('refresh-token');

        if(!refresh_token){
            return null
        }

        const valid = jwt.verify(refresh_token.value, String(process.env.REFRESH_TOKEN_SECRET))

        if(!valid){
            return null
        }

        const user = await prisma.user.findFirst({ where: {id: String(valid)}})

        if(!user){
            return null
        }

        return user
    }catch(err){
        console.log(err)
        return NextResponse.json({ err: "Problems with auth" }, { status: 500 });
    }
}