export type User = {
  id: string
  email: string
  username: string
  password: string
  role: number
}

export type Event = {
  id: string
  title: string
  description: string
  location: string
  date: Date
  image: string
  visible: boolean
}

export type TicketType = {
  id: string
  eventId: string
  name: string,
  price: number
  qty: number
}

export type Ticket = {
  id: string
  ticketnr: string
  userId: string
  eventId: string
  ttypeId: string
  status: number
  scandate: Date
}

export type Session = {
  user:{
    id: string
    username: string
    role: number
  }
}

export type CartItem = {
    id: string
    title: string
    price: number
    quantity: number
    eventId: string
    event: {
      id: string
      title: string
    },
}