import prisma from "@/lib/prisma";
import { NextRequest, NextResponse } from "next/server";

export const ticketCtrl = {
    ticketGet: async (req: NextRequest) => {
        const tickets = await prisma.ticket.findMany();

        return NextResponse.json(tickets)
    },

    eticketGet: async (req: NextRequest) => {
        const { ticketId, eventId }  = await req.json()

        const ticket = await prisma.ticket.findFirst({ where: { ticketnr: ticketId, scandate: null, eventId: eventId }})

        return NextResponse.json(ticket)
    },

    tTypeGet: async (req: NextRequest) => {
        const ttype = await prisma.ticketType.findMany();

        return NextResponse.json(ttype)
    },

    ticketCreate: async (req: NextRequest) => {
        const { ticketnr, userId, eventId, ttypeId }  = await req.json()

        const ticket = await prisma.ticket.create({ data: { ticketnr: ticketnr, userId: userId, eventId: eventId, ttypeId: ttypeId, status: 0, scandate: null }})

        return NextResponse.json(ticket)
    },
    
    tTypeCreate : async (req: NextRequest) => {
        const { eventId, name, price, qty }  = await req.json()

        const type = await prisma.ticketType.create({ data: { name, eventId, price, qty } })

        return NextResponse.json(type)
    },

    tUpdate: async (req: NextRequest) =>  {
        const { ticketId, eventId }  = await req.json()

        const ticket = await prisma.ticket.update({ where: { ticketnr: ticketId, eventId: eventId }, data: {scandate: new Date()} })

        return NextResponse.json(ticket)
    }
}