import prisma from "@/lib/prisma";
import { NextRequest, NextResponse } from "next/server";

export const eventCtrl = {
    create : async (req: NextRequest) => {
        const { title, image, date, location } = await req.json()

        const event = await prisma.events.create({ data: {title: title, image: image, date: date, location: location}})

        return NextResponse.json(event)
    },

    eventGet: async (req: NextRequest) => {
        const events = await prisma.events.findMany();

        return NextResponse.json(events)
    },

    event: async (req: NextRequest) => {
        const { eventId }  = await req.json()
        const event = await prisma.events.findFirst({ where: {id: eventId}})

        if(!event){
            return NextResponse.json({ message: "Event not found" }, { status: 404 })
        }

        return NextResponse.json(event)
    }
}