"use client"

import { useAppStore } from "@/lib/store"
import { Squares2X2Icon, BanknotesIcon, QrCodeIcon, UserIcon } from "@heroicons/react/24/outline"
import Link from "next/link"

const Navigation = () => {
    const { user } = useAppStore()

    return(
        <div className="w-full h-16 sm:h-14 p-2 sm:p-0 flex gap-3 items-center justify-between sm:justify-center sticky bottom-0 sm:top-0 left-0 border-t sm:border-t-0 sm:border-b bg-neutral-100 border-neutral-300">
            <Link href={'/events'} className="w-full sm:w-max px-[10px] py-2 flex flex-col sm:flex-row gap-[2px] sm:gap-2 items-center justify-center rounded-md sm:hover:bg-neutral-100">
                <Squares2X2Icon className="size-6 sm:size-5 text-neutral-500"/>
                <span className="text-[10px] sm:text-sm text-neutral-500 font-medium">Events</span>
            </Link>
            {user?.role === 1 && (
                <Link href={'/scan'} className="w-full sm:w-max px-[10px] py-2 flex flex-col sm:flex-row gap-[2px] sm:gap-2 items-center justify-center rounded-md sm:hover:bg-neutral-100">
                    <QrCodeIcon className="size-6 sm:size-5 text-neutral-500"/>
                    <span className="text-[10px] sm:text-sm text-neutral-500 font-medium">Scan</span>
                </Link>
            )}
            <Link href={'/profile'} className="w-full sm:w-max px-[10px] py-2 flex flex-col sm:flex-row gap-[2px] sm:gap-2 items-center justify-center rounded-md sm:hover:bg-neutral-100">
                <UserIcon className="size-6 sm:size-5 text-neutral-500"/>
                <span className="text-[10px] sm:text-sm text-neutral-500 font-medium">Profile</span>
            </Link>
        </div>
    )
}

export default Navigation