import { useAppStore } from "@/lib/store"
import { TrashIcon } from "@heroicons/react/24/outline"

const Basket = () => {
    const { cart, removeFromCart, updateCartQuantity } = useAppStore()

    return(
        <div className="grow space-y-2 py-2 overflow-y-scroll">
            {cart.map((i) => (
                <div key={i.id} className="flex items-center justify-between border border-neutral-200 rounded-md p-4">
                    <div className="space-y-1">
                        <h1 className="text-xl font-semibold tracking-tight">{i.event.title}</h1>
                        <h1>{i.title}</h1>
                        <div className="flex gap-2 items-center">
                            <h1 className="text-neutral-500">QTY:</h1>
                            <div className="flex gap-2 items-center">
                                <h1 className="h-6 w-6 flex items-center justify-center border border-neutral-200 rounded-full cursor-pointer" onClick={() => updateCartQuantity(i.id, i.quantity - 1)}>-</h1>
                                <h1>{i.quantity}</h1>
                                <h1 className="h-6 w-6 flex items-center justify-center border border-neutral-200 rounded-full cursor-pointer" onClick={() => updateCartQuantity(i.id, i.quantity + 1)}>+</h1>
                            </div>
                        </div>
                        
                    </div>
                    <div className="flex items-center gap-2">
                        <h1 className="text-xl font-semibold tracking-tight ">{(i.price * i.quantity).toFixed(2)}</h1>
                        <TrashIcon className="size-5 hover:stroke-red-500 cursor-pointer transition-colors" onClick={() => removeFromCart(i.id) }/>
                    </div>
                </div>
            ))}  
            
        </div>
    )
}

export default Basket