<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Iegūstam caurlaidi pēc ID
    $id = $_GET['id'] ?? null;
    if (!$id) {
        die("ID ir obligāts.");
    }
    
    $stmt = $pdo->prepare("SELECT * FROM passes WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $caurlaide = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$caurlaide) {
        die("Caurlaide ar šo ID netika atrasta.");
    }

    // Apstrādā formu nosūtīšanu (POST pieprasījums)
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Iegūstam jaunos datus no formas
        $name = trim($_POST['name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $date = $_POST['date'] ?? '';
        $remaining = $_POST['remaining'] ?? '';

        // Validācija
        if (empty($name) || empty($phone) || empty($date) || empty($remaining)) {
            echo "Visi lauki jāaizpilda.";
            exit;
        }

        // Validējam telefona numuru (piemērs ar regulāro izteiksmi)
        if (!preg_match("/^\+?\d{8,15}$/", $phone)) {
            echo "Nederīgs telefona numurs.";
            exit;
        }

        // Validējam datumu, lai tas nebūtu pagātnē
        if (strtotime($date) < time()) {
            echo "Datums nevar būt pagātnē.";
            exit;
        }

        // Izpildām SQL vaicājumu, lai atjauninātu datus
        $stmt = $pdo->prepare("UPDATE passes SET name = :name, phone = :phone, date = :date, remaining = :remaining WHERE id = :id");
        $stmt->execute([
            'name' => $name,
            'phone' => $phone,
            'date' => $date,
            'remaining' => $remaining,
            'id' => $id
        ]);

        // Pāradresē uz caurlaides skatīšanas lapu ar jaunajiem datiem
        header("Location: uznemums.show.php?id=" . urlencode($id));
        exit;
    }

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Labot caurlaidi</title>
    <link rel="stylesheet" href="../css/edit.css">
</head>
<body>
    <div class="container">
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/caurlaidesapp/sargs/sargs.index.php">Sargs</a></li>
                    <li class="menu-item"><a href="/caurlaidesapp/uznemums/uznemums.index.php">Uzņēmums</a></li>
                    <li class="menu-item"><a href="/caurlaidesapp/admin/admin.index.php">Administrācija</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Labot caurlaidi #<?= htmlspecialchars($caurlaide['id']) ?></h1>
            <p>Šeit varat mainīt viesa informāciju.</p>

            <form method="POST" action="">
                <input type="hidden" name="id" value="<?= htmlspecialchars($caurlaide['id']) ?>">

                <div class="form-group">
                    <label for="name">Vārds Uzvārds</label>
                    <input type="text" name="name" id="name" value="<?= htmlspecialchars($caurlaide['name']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="phone">Telefona numurs</label>
                    <input type="text" name="phone" id="phone" value="<?= htmlspecialchars($caurlaide['phone']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="date">Apmeklēšanas datums</label>
                    <?php
                    $formatted_date = date("Y-m-d\TH:i", strtotime($caurlaide['date']));
                    ?>
                    <input type="datetime-local" name="date" id="date" value="<?= htmlspecialchars($formatted_date) ?>" required>
                </div>

                <div class="form-group">
                    <label for="remaining">Apmeklēšanas reizes</label>
                    <input type="text" name="remaining" id="remaining" value="<?= htmlspecialchars($caurlaide['remaining']) ?>" required>
                </div>

                <div class="form-actions">
                    <a href="uznemums.show.php?id=<?= urlencode($caurlaide['id']); ?>" class="btn btn-cancel">ATCELT</a>
                    <button type="submit" class="btn btn-save">SAGLABĀT</button>
                </div>
            </form>
        </main>
    </div>
</body>
</html>