<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Ja forma ir nosūtīta
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Iegūstam formu datus
        $name = trim($_POST['name'] ?? '');
        $company_id = $_POST['company_id'] ?? '';
        $phone = trim($_POST['phone'] ?? '');
        $date = $_POST['date'] ?? '';
        $remaining = $_POST['remaining'] ?? '';

        // Pārbaude, vai visi nepieciešamie dati ir nodoti
        if (empty($name) || empty($company_id) || empty($phone) || empty($date) || empty($remaining)) {
            echo 'Visi lauki jāaizpilda.';
            exit;
        }

        // Validējam telefona numuru (piemērs ar regulāro izteiksmi)
        if (!preg_match("/^\+?\d{8,15}$/", $phone)) {
            echo "Nederīgs telefona numurs.";
            exit;
        }

        // Validējam datumu, lai tas nebūtu pagātnē
        if (strtotime($date) < time()) {
            echo "Datums nevar būt pagātnē.";
            exit;
        }

        // Ģenerē sešciparu PIN un QR
        $PIN = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
        $QR = str_pad(rand(0, 9999999999), 10, '0', STR_PAD_LEFT);

        try {
            // Ievadām jaunu caurlaidi datubāzē
            $stmt = $pdo->prepare("INSERT INTO passes (name, PIN, QR, company_id, phone, date, remaining) VALUES (:name, :PIN, :QR, :company_id, :phone, :date, :remaining)");
            $stmt->execute([
                ':name' => $name,
                ':PIN' => $PIN,
                ':QR' => $QR,
                ':company_id' => $company_id,
                ':phone' => $phone,
                ':date' => $date,
                ':remaining' => $remaining,
            ]);
        } catch (PDOException $e) {
            die("Kļūda saglabājot datus: " . $e->getMessage());
        }

        // Pāradresējam uz saraksta lapu pēc pievienošanas
        $lastId = $pdo->lastInsertId();
        header("Location: uznemums.show.php?id=$lastId");
        exit;
    }

    // Iegūstam uzņēmumu sarakstu, lai parādītu izvēlni formā
    $stmt = $pdo->prepare("SELECT id, name FROM companies");
    $stmt->execute();
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauna Caurlaide</title>
    <link rel="stylesheet" href="../css/create.css">
    <script src="/js/uznemums.js"></script>
</head>
<body>
    <div class="container">
        <!-- Header ar izvēlnēm -->


        <main>
            <h1>Jauna Caurlaide</h1>
            <p>Šeit varat pievienot jaunu viesi.</p>

            <!-- Jauna caurlaide forma -->
            <form action="uznemums.create.php" method="POST">
                <label for="name">Viesis:</label>
                <input type="text" name="name" id="name" required placeholder="Ievadiet viesi">

                <label for="company_id">Uzņēmums:</label>
                <select name="company_id" id="company_id" required>
                    <option value="">Izvēlēties uzņēmumu</option>
                    <?php foreach ($companies as $company): ?>
                        <option value="<?= htmlspecialchars($company['id']) ?>"><?= htmlspecialchars($company['name']) ?></option>
                    <?php endforeach; ?>
                </select>

                <label for="phone">Telefons:</label>
                <input type="text" name="phone" id="phone" required placeholder="Ievadiet telefonu">

                <label for="date">Datums un laiks:</label>
                <input type="datetime-local" name="date" id="date" required>

                <label for="remaining">Atlikušas reizes:</label>
                <input type="number" name="remaining" id="remaining" required placeholder="Ievadiet atlikušās reizes" min="0">

                <div class="button-group">
            <a href="uznemums.index.php" class="btn-secondary">Atpakaļ</a>
            <button type="submit" class="btn-success">Saglabāt</button>
        </div>

        <!-- Footer -->
        <footer>
        </footer>
    </div>
</body>
</html>