<?php
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

// Pārbaudi, vai ID ir pieprasījumā
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('Caurlaides ID nav norādīts vai ir nederīgs.');
}

$id = intval($_GET['id']); // Sanitizācija (drošība)

try {
    // Savienojums ar datubāzi
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Izgūst konkrētās caurlaides datus no datubāzes
    $stmt = $pdo->prepare("
        SELECT 
            p.id, 
            p.name, 
            p.date, 
            p.PIN, 
            p.remaining, 
            p.phone, 
            p.QR, 
            c.name AS company_name
        FROM passes p
        LEFT JOIN companies c ON p.company_id = c.id
        WHERE p.id = :id
    ");
    $stmt->execute(['id' => $id]);
    $caurlaide = $stmt->fetch(PDO::FETCH_ASSOC);

    // Ja caurlaide netika atrasta
    if (!$caurlaide) {
        die('Caurlaide nav atrasta.');
    }
} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
        <html lang="lv">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Caurlaide Nr. <?= htmlspecialchars($caurlaide['id']); ?></title>
        <link rel="stylesheet" href="../css/show.css">
    </head>
    <body>
        <div class="<?= $caurlaide['remaining'] > 0 ? 'bg-green-200' : 'bg-red-200'; ?> container">
            <h1>Caurlaide Nr. <?= htmlspecialchars($caurlaide['id']); ?></h1>
            <p>Šeit redzama viena caurlaide.</p>

            <dl>
                <dt>Vārds, uzvārds:</dt>
                <dd><?= htmlspecialchars($caurlaide['name']); ?></dd>

                <dt>Uzņēmums:</dt>
                <dd><?= htmlspecialchars($caurlaide['company_name']); ?></dd>

                <dt>Telefona numurs:</dt>
                <dd><?= htmlspecialchars($caurlaide['phone']); ?></dd>

                <dt>Apmeklēšanas datums:</dt>
                <dd><?= htmlspecialchars($caurlaide['date']); ?></dd>

                <dt>PIN:</dt>
                <dd><?= htmlspecialchars($caurlaide['PIN']); ?></dd>

                <dt>QR kods:</dt>
                <dd><?= htmlspecialchars($caurlaide['QR']); ?></dd>

                <dt>Atlikušās apmeklēšanas reizes:</dt>
                <dd><?= htmlspecialchars($caurlaide['remaining']); ?></dd>
            </dl>

            <a href="sargs.index.php" class="btn btn-secondary">Atpakaļ</a>
        </div>
    </body>
</html>