<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

try {
$pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Iegūt URL parametrus
$company_id = $_GET['company_id'] ?? null;
$user_id = $_GET['user_id'] ?? null;

if (!$company_id || !$user_id) {
die("Nepareizi parametri.");
}

// Datu iegūšana par darbinieku
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :user_id AND company_id = :company_id");
$stmt->execute([
':user_id' => $user_id,
':company_id' => $company_id
]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
die("Darbinieks nav atrasts.");
}

} catch (PDOException $e) {
die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Darbinieka Informācija</title>
<link rel="stylesheet" href="../css/adminuser.show.css">
</head>
<body>
<h1>Darbinieka Informācija</h1>

<p><strong>Vārds:</strong> <?= htmlspecialchars($user['name']) ?></p>
<p><strong>E-pasts:</strong> <?= htmlspecialchars($user['email']) ?></p>
<p><strong>Telefons:</strong> <?= htmlspecialchars($user['phone']) ?></p>
<p><strong>Uzņēmums (ID):</strong> <?= htmlspecialchars($user['company_id']) ?></p>
<p><strong>Izveidots:</strong> <?= htmlspecialchars($user['created_at']) ?></p>

<div class="actions">
            <a href="adminuser.edit.php?id=<?= htmlspecialchars($user['id']); ?>" class="btn btn-edit">EDIT</a>
            <a href="adminuser.delete.php?id=<?= htmlspecialchars($user['id']); ?>" 
   class="btn btn-delete" 
   onclick="return confirm('Vai tiešām vēlaties dzēst šo darbinieku?')">
   DELETE
</a>
            <a href="/caurlaidesapp/admin/admin.index.php" class="btn btn-secondary">Atpakaļ</a>
        </div>
</body>
</html>