<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

// Iegūt `company_id` no URL, ja tāds ir pieejams
$company_id = $_GET['company_id'] ?? null;

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Ja forma ir iesniegta
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $password = trim($_POST['password'] ?? '');
        $company_id = intval($_POST['company_id'] ?? 0);

        // Validācija
        if (empty($name) || empty($email) || empty($phone) || empty($password) || $company_id === 0) {
            echo 'Visi lauki jāaizpilda.';
            exit;
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            echo 'Nederīgs e-pasta formāts.';
            exit;
        }

        // Paroles šifrēšana
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Datu saglabāšana datubāzē
        $stmt = $pdo->prepare("INSERT INTO users (name, email, phone, password, company_id, created_at) VALUES (:name, :email, :phone, :password, :company_id, NOW())");
        $stmt->execute([
            ':name' => $name,
            ':email' => $email,
            ':phone' => $phone,
            ':password' => $hashed_password,
            ':company_id' => $company_id
        ]);
        $user_id = $pdo->lastInsertId();
        header("Location: adminuser.show.php?company_id=$company_id&user_id=$user_id");
        exit;
    }

    // Uzņēmumu iegūšana formu izvēlei
    $stmt = $pdo->query("SELECT id, name FROM companies");
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pievienot jaunu darbinieku</title>
    <link rel="stylesheet" href="../css/adminuser.create.css">
</head>
<body>
    <h1>Pievienot jaunu darbinieku:</h1>
    <form method="POST" action="adminuser.create.php">
        <label for="name">Vārds:</label><br>
        <input type="text" id="name" name="name" required><br><br>

        <label for="email">E-pasts:</label><br>
        <input type="email" id="email" name="email" required><br><br>

        <label for="password">Parole:</label><br>
        <input type="password" id="password" name="password" required><br><br>

        <label for="phone">Telefons:</label><br>
        <input type="text" id="phone" name="phone"><br><br>

        <label for="company_id">Uzņēmums:</label>
        <select name="company_id" id="company_id" required>
            <option value="">Izvēlēties uzņēmumu</option>
            <?php foreach ($companies as $company): ?>
                <option value="<?= htmlspecialchars($company['id']) ?>">
                    <?= htmlspecialchars($company['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="submit">Saglabat</button>
    </form>
</body>
</html>



