<?php
$host = 'localhost';
$dbname = 'caurlaidesapp';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Iegūstam kompānijas ID
$companyId = $_GET['id'] ?? 0;

// Iegūstam kompānijas detaļas
$stmt = $pdo->prepare("SELECT * FROM companies WHERE id = :id");
$stmt->execute(['id' => $companyId]);
$company = $stmt->fetch(PDO::FETCH_ASSOC);

// Iegūstam caurlaides
$stmt = $pdo->prepare("SELECT * FROM passes WHERE company_id = :id");
$stmt->execute(['id' => $companyId]);
$passes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Iegūstam darbiniekus
$stmt = $pdo->prepare("SELECT * FROM users WHERE company_id = :id");
$stmt->execute(['id' => $companyId]);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kompānijas detaļas</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/admin.show.css">
</head>
<body>
<div class="container">
    <!-- Kompānijas info -->
    <div class="company-card">
        <h1 class="company-title"><?= htmlspecialchars($company['name']) ?></h1>
        <p class="company-address"><strong>Adrese:</strong> <?= htmlspecialchars($company['address']) ?></p>
    </div>  
        <!-- Caurlaides -->
        <div class="section">
            <h2>Caurlaides: </h2>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Viesa vārds</th>
                        <th>Datums</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($passes): ?>
                        <?php foreach ($passes as $pass): ?>
                            <tr>
                                <td><?= htmlspecialchars($pass['name']) ?></td>
                                <td><?= htmlspecialchars($pass['date']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2" class="no-data">Nav caurlaižu</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Darbinieki -->
        <div class="section">
            <h2>Darbinieki:</h2>
            <div class="new-pass-btn">
                <a href="/caurlaidesapp/adminuser/adminuser.create.php" class="btn btn-success">Pievienot</a>
            </div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Vārds, Uzvārds</th>
                        <th>E-pasts</th>
                        <th>Telefons</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($users): ?>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?= htmlspecialchars($user['name']) ?></td>
                                <td><?= htmlspecialchars($user['email']) ?></td>
                                <td><?= htmlspecialchars($user['phone']) ?></td>
                                <td><a href="/caurlaidesapp/adminuser/adminuser.show.php?company_id=<?= htmlspecialchars($company['id']); ?>&user_id=<?= htmlspecialchars($user['id']); ?>" class="btn btn-primary">Apskatīt</a></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="no-data">Nav darbinieku</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="actions">
            <a href="admin.edit.php?id=<?= htmlspecialchars($company['id']); ?>" class="btn btn-edit">EDIT</a>
            <a href="admin.delete.php?id=<?= htmlspecialchars($company['id']); ?>" 
   class="btn btn-delete" 
   onclick="return confirm('Vai tiešām vēlaties dzēst šo caurlaidi?')">
   DELETE
</a>
            <a href="admin.index.php" class="btn btn-secondary">Atpakaļ</a>
        </div>
    </div>
</body>
</html>
