<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Meklēšanas parametra apstrāde
    $search = $_GET['search'] ?? '';
    $searchQuery = '';
    $params = [];

    if (!empty($search)) {
        $searchQuery = " WHERE name LIKE :search";
        $params['search'] = '%' . $search . '%';
    }

    // Kompāniju saraksta iegūšana no datubāzes
    $stmt = $pdo->prepare("
    SELECT 
        id, 
        name, 
        address
    FROM companies
    $searchQuery
    ");
    
    $stmt->execute($params);  // Pārraida parametru vērtības
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kompāniju saraksts - Administrācija</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
    <div class="container">
        <!-- Header ar izvēlnēm -->
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/caurlaidesapp/sargs/sargs.index.php">Sargs</a></li>
                    <li class="menu-item"><a href="/caurlaidesapp/uznemums/uznemums.index.php">Uzņēmums</a></li>
                    <li class="menu-item"><a href="/caurlaidesapp/admin/admin.index.php">Administrācija</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Kompānijas</h1>

            <!-- Poga "Jauna kompānija" -->
            <div class="new-company-btn">
                <a href="admin.create.php" class="btn btn-success">Pievienot jaunu kompāniju</a>
            </div>

            <!-- Meklēšanas forma -->
            <form class="search-form" method="GET">
                <input type="text" name="search" id="search" placeholder="Meklēt kompāniju" value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
                <button type="submit">Meklēt</button>
            </form>

            <!-- Tabula -->
            <table>
                <thead>
                    <tr>
                        <th>Kompānijas nosaukums</th>
                        <th>Adrese</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($companies)): ?>
                        <?php foreach ($companies as $company): ?>
                            <tr>
                                <td><?= htmlspecialchars($company['name']) ?></td>
                                <td><?= htmlspecialchars($company['address']) ?></td>
                                <td><a href="admin.show.php?id=<?= urlencode($company['id']); ?>" class="btn btn-primary">Apskatīt</a></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5">Nav atrasti dati.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </main>
    </div>
</body>
</html>
