import { useState, useEffect } from "react"; // importē stāvokli un efektus
import FullCalendar from "@fullcalendar/react"; // importē kalendāru
import dayGridPlugin from "@fullcalendar/daygrid"; // mēneša skats
import timeGridPlugin from "@fullcalendar/timegrid"; // dienas un nedēļas skati
import interactionPlugin from "@fullcalendar/interaction"; // atļauj klikšķus
import { Moon, Sun } from "lucide-react"; // importē ikonas
import "./index.css"; // stili

export default function App() {
  const [events, setEvents] = useState([]); // glabā notikumus
  const [darkMode, setDarkMode] = useState(() => localStorage.getItem("dark") === "true"); // glabā dark mode stāvokli

  useEffect(() => {
    const stored = JSON.parse(localStorage.getItem("events")) || []; // iegūst notikumus no local storage
    setEvents(stored); // uzstāda notikumus
  }, []);

  useEffect(() => {
    localStorage.setItem("events", JSON.stringify(events)); // saglabā notikumus local storage
  }, [events]);

  useEffect(() => {
    document.documentElement.classList.toggle("dark", darkMode); // pārslēdz dark klasi html elementam
    localStorage.setItem("dark", darkMode); // saglabā dark mode stāvokli
  }, [darkMode]);

  const handleDateClick = (arg) => {
    const title = prompt("enter task name:"); // prasa lietotājam ievadīt uzdevuma nosaukumu
    if (title) {
      const newEvent = { title, date: arg.dateStr }; // izveido jaunu notikumu
      setEvents([...events, newEvent]); // pievieno notikumu sarakstam
    }
  };

  return (
    <div className="min-h-screen bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white p-6">
      <div className="flex justify-between items-center mb-6">
        <h1 className="text-2xl font-bold">work planner</h1> {/* virsraksts */}
        <button onClick={() => setDarkMode(!darkMode)} className="p-2 rounded-full bg-gray-300 dark:bg-gray-700">
          {/* poga tumšajam režīmam */}
          {darkMode ? <Sun size={20} /> : <Moon size={20} />}
        </button>
      </div>
      <FullCalendar
        plugins={[dayGridPlugin, timeGridPlugin, interactionPlugin]} // pievieno pluginus
        initialView="dayGridMonth" // sākuma skats
        events={events} // notikumu saraksts
        dateClick={handleDateClick} // funkcija klikšķim uz dienas
        height="auto" // automātisks augstums
      />
    </div>
  );
}
