async function Load() {
    const topicName = window.location.href.split("?view=")[1];
    $("#TravelToIndexPage").on("click", function() {
        Link("/");
    });
    $("#TravelToTopicPage").on("click", function() {
        Link(topicName);
    });
    await $.ajax({
        url: "/universal/get_topics/name/" + topicName,
        method: "GET",
        success: async function(response) {
            $("#TopicTitle").html("Topic: " + response[0].name);
            $("#TopicDescription").html(response[0].description);
            await $.ajax({
                url: "/universal/get_categories/topic_id/" + response[0].id,
                method: "GET",
                success: function(answer) {
                    for (let _ = 0; _ < answer.length; _++) {
                        $("#TopicCategoryList").append(`<button onclick='CategoryButton("` + answer[_].id + `")'>` + answer[_].name + `</button><br>`);
                    }
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}
function CategoryButton(value) {
    Link("/category?view=" + value);
}