async function Load() {
    const articalId = window.location.href.split("?view=")[1];
    $("#TravelBackToArtical").on("click", function() {
        Link("/artical?view=" + articalId);
    });
    $("#SaveChanges").on("click", function() {
        //saves
    });
    await $.ajax({
        url: "/universal/get_articals/id/" + articalId,
        method: "GET",
        success: async function(response) {
            let sectionArray = [];
            let str = String(JSON.parse(response[0].sections).sections);
            let sendingString = "";
            for (let _ = 0; _ < str.length; _++) {
                if (str[_] == ",") {
                    sendingString += "-";
                }
                else {
                    sendingString += str[_];
                }
            }
            await $.ajax({
                url: "/sections/" + sendingString,
                method: "GET",
                success: function(answer) {
                    sectionArray = answer;
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
            await $.ajax({
                url: "/universal/get_topics/id/" + response[0].topic_id,
                method: "GET",
                success: function(answer) {
                    $("#TravelToTopicPage").on("click", function() {
                        Link("/topic?view=" + answer[0].name);
                    });
                    $("#TopicTitle").html("Topic: " + answer[0].name);
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
            $("#ArticalTitle").val("Artical: " + response[0].name);
            $("#ArticalDescription").html(response[0].description);
            for (let _ = 0; _ < sectionArray.length; _++) {
                $("#ArticalSections").append(`<div id='section` + _ + `'><div><input value=''><br><textarea value=''></textarea></div><div><br><button onclick='AddSection(` + _ + `)'>+</button> <button onclick='RemoveSection(` + _ + `)'>-</button> <button onclick='MoveSection(` + _ + `, "up")'>/\\</button> <button onclick='MoveSection(` + _ + `, "down")'>\\/</button><hr></div></div>`);
                $("#section" + _).find("input").val(sectionArray[_].title);
                $("#section" + _).find("textarea").val(sectionArray[_].body);
            }
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}
function AddSection(section) {
    console.log("Add section under section" + section);
    $("#ArticalSections").append(`<div id='section` + $("#ArticalSections").children().get().length + `'><div><input value='title'><br><textarea value=''>description</textarea></div><div><br><button onclick='AddSection(` + $("#ArticalSections").children().get().length + `)'>+</button> <button onclick='RemoveSection(` + $("#ArticalSections").children().get().length + `)'>-</button> <button onclick='MoveSection(` + $("#ArticalSections").children().get().length + `, "up")'>/\\</button> <button onclick='MoveSection(` + $("#ArticalSections").children().get().length + `, "down")'>\\/</button><hr></div></div>`);
    /* let currentSections = $("#ArticalSections").children().get();
    let test = currentSections;
    let newDiv = currentSections[currentSections.length - 1];
    for (let _ = $("#ArticalSections").children().get().length - 1; _ >= 0; _--) {
        console.log("section" + section + " == " + _);
        if (_ > section) {
            console.log(_);
            if (_ - 1 == section) {
                
            }
            else {
                $($(currentSections[_ - 1]).children().get()[0]).insertBefore($($(currentSections[_]).children().get()[0]));
            }
        }
    } */
}
function RemoveSection(section) {
    if ($("#ArticalSections").children().get().length - 1 > 0) {
        let selectedDiv = $("#section" + section).children().get();
        $(selectedDiv[0]).remove();
        for (let _ = 0; _ < $("#ArticalSections").children().get().length; _++) {
            if (_ > section) {
                let moveDiv = $("#section" + _).children().get()[0];
                $(moveDiv).insertBefore($("#section" + Number(_ - 1)).find("div"));
            }
            if (_ + 1 == $("#ArticalSections").children().get().length) {
                $("#section" + _).remove();
            }
        }
    }
}
function MoveSection(section, toPosition) {
    if (toPosition == "up") {
        if (Number(section - 1) > -1) {
            let selectedDiv = $("#section" + section).children().get();
            let otherDiv = $("#section" + Number(section - 1)).children().get();
            $("#section" + section).html($(otherDiv[0]));
            $("#section" + section).append($(selectedDiv[1]));
            $("#section" + Number(section - 1)).html($(selectedDiv[0]));
            $("#section" + Number(section - 1)).append($(otherDiv[1]));
        }
    }
    else {
        if (Number(section + 1) < $("#ArticalSections").children().get().length) {
            let selectedDiv = $("#section" + section).children().get();
            let otherDiv = $("#section" + Number(section + 1)).children().get();
            $("#section" + section).html($(otherDiv[0]));
            $("#section" + section).append($(selectedDiv[1]));
            $("#section" + Number(section + 1)).html($(selectedDiv[0]));
            $("#section" + Number(section + 1)).append($(otherDiv[1]));
        }
    }
}