async function Load() {
    const categoryId = window.location.href.split("?view=")[1];
    $("#TravelToIndexPage").on("click", function() {
        Link("/");
    });
    await $.ajax({
        url: "/universal/get_categories/id/" + categoryId,
        method: "GET",
        success: async function(response) {
            await $.ajax({
                url: "/universal/get_topics/id/" + response[0].topic_id,
                method: "GET",
                success: function(answer) {
                    $("#TravelToTopicPage").on("click", function() {
                        Link("/topic/" + answer[0].name);
                    });
                    $("#TopicTitle").html("Topic: " + answer[0].name);
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
            $("#CategoryTitle").html("Category: " + response[0].name);
            $("#CategoryDescription").html(response[0].description);
            await $.ajax({
                url: "/getCtgrArtcls/id/" + response[0].topic_id + "/" + categoryId,
                method: "GET",
                success: function(answer) {
                    for (let _ = 0; _ < answer.length; _++) {
                        $("#ListOfArticals").append(`<button onclick='ArticalButton("` + answer[_].id + `")'>` + answer[_].name + `</button><br>`);
                    }
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}
function ArticalButton(value) {
    Link("/artical?view=" + value);
}