async function Load() {
    const articalId = window.location.href.split("?view=")[1];
    $("#TravelToIndexPage").on("click", function() {
        Link("/");
    });
    $("#TravelToEditPage").on("click", function() {
        Link("/edit/artical?view=" + articalId);
    });
    await $.ajax({
        url: "/universal/get_articals/id/" + articalId,
        method: "GET",
        success: async function(response) {
            let sectionArray = [];
            let str = String(JSON.parse(response[0].sections).sections);
            let sendingString = "";
            for (let _ = 0; _ < str.length; _++) {
                if (str[_] == ",") {
                    sendingString += "-";
                }
                else {
                    sendingString += str[_];
                }
            }
            await $.ajax({
                url: "/sections/" + sendingString,
                method: "GET",
                success: function(answer) {
                    sectionArray = answer;
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
            await $.ajax({
                url: "/universal/get_topics/id/" + response[0].topic_id,
                method: "GET",
                success: function(answer) {
                    $("#TravelToTopicPage").on("click", function() {
                        Link("/topic?view=" + answer[0].name);
                    });
                    $("#TopicTitle").html("Topic: " + answer[0].name);
                },
                error: function(answer) {
                    console.log(answer.responseJSON);
                }
            });
            $("#ArticalTitle").html("Artical: " + response[0].name);
            $("#ArticalDescription").html(response[0].description);
            $("#ArticalSectionTitles").append("<a href=\"#ArticalTitle\">Description</a><br>");
            for (let _ = 0; _ < sectionArray.length; _++) {
                $("#ArticalSectionTitles").append("<a href=\"#section" + Number(_ + 1) + "\">" + sectionArray[_].title + "</a><br>");
                $("#ArticalSections").append("<div id=\"section" + Number(_ + 1) + "\"><h3>" + sectionArray[_].title + "</h3>" + sectionArray[_].body + "</div>");
            }
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}