<?php
 
namespace App\Controllers;

use Config\Database;
use CodeIgniter\RESTful\ResourceController;
 
class UniversalController extends ResourceController
{
    protected $format = "json";

    public function ViewTopic(): string
    {
        return view("topic.html");
    }

    public function ViewCategory(): string
    {
        return view("category.html");
    }

    public function ViewArtical(): string
    {
        return view("artical.html");
    }

    public function EditPage($pageType = null): string
    {
        return view("edit_".$pageType.".html");
    }

    public function Index()
    {
        /* $db = Database::connect();
        $builder = $db->table("forms");
        $query = $builder->select("table_name")->get();
        $responses = [];
        foreach ($query->getResult() as $row) {
            $name = $row->table_name;
            $data = $db->table($name)->get()->getResult();
            $responses[] = $data;
        }
        return $this->respond($responses, 200); */
    }

    public function Show($viewTable = null, $searchColumn = null, $searchValue = null)
    {
        if ($viewTable != null) {
            $db = Database::connect();
            if (is_null($searchColumn) && is_null($searchValue)) {
                $query = $db->query('SELECT * FROM '.$viewTable.' AS t WHERE t.'.$searchColumn.' = '.$searchValue.'')->getResult();
            }
            else {
                $query = $db->query('SELECT * FROM '.$viewTable)->getResult();
            }
            return $this->respond($query, 200);
        }
        else {
            return $this->fail(["error" => "Not found"], 404);
        }
    }

    public function GetCategoryArticals($searchColumn = null, $searchValue = null, $categoryId = null) {
        $db = Database::connect();
        if (is_null($searchColumn) || is_null($searchValue)) {
            return $this->fail(["error" => "Not found"], 404);
        }
        $query = $db->query('SELECT * FROM get_articals AS t WHERE t.'.$searchColumn.' = '.$searchValue.'')->getResult();
        $result = [];
        foreach ($query as $obj) {
            $currentObj = trim(explode(":", $obj->categories)[1], "{[ ]}");
            $num = "";
            for ($_ = 0; $_ < strlen($currentObj); $_++) {
                if ($currentObj[$_] == ",") {
                    if ($categoryId == $num) {
                        $result[] = $obj;
                    }
                    $num = "";
                }
                else {
                    $num .= $currentObj[$_];
                    if (strlen($currentObj) == $_ + 1) {
                        if ($categoryId == $num) {
                            $result[] = $obj;
                        }
                    }
                }
            }
        }
        return $this->respond($result, 200);
    }

    public function GetSections($sectionArray = null) {
        $db = Database::connect();
        $result = [];
        $num = "";
        for ($_ = 0; $_ < strlen($sectionArray); $_++) {
            if ($sectionArray[$_] == "-") {
                $result[] = $db->query('SELECT * FROM get_sections AS t WHERE t.id = '.$num.'')->getRow();
                $num = "";
            }
            else {
                $num .= $sectionArray[$_];
                if (strlen($sectionArray) == $_ + 1) {
                    $result[] = $db->query('SELECT * FROM get_sections AS t WHERE t.id = '.$num.'')->getRow();
                }
            }
        }
        return $this->respond($result, 200);
    }
}