function Load() {
    const ticketID = document.location.href.split("/")[document.location.href.split("/").length - 1];
    let userID;
    $.ajax({
        url: "/GetTickets/" + ticketID + "/0",
        method: "GET",
        success: function(response) {
            $("#InputName").val(response[0].name);
            $("#InputDescription").val(response[0].description);
            $("#InputStatus").val(response[0].status);
            userID = response[0].user_id;
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
    $("#SubmitEditBtn").on("click", function() {
        const currentDate = new Date();
        let dateStuff = [currentDate.getMonth() + 1, currentDate.getDate(), currentDate.getHours(), currentDate.getMinutes(), currentDate.getSeconds()];
        let dateParts = [];
        for (let _ = 0; _ < 5; _++) {
            if (String(dateStuff[_]).length == 1) {
                dateParts.push(String("0" + dateStuff[_]));
            }
            else {
                dateParts.push(String(dateStuff[_]));
            }
        }
        let date = currentDate.getFullYear() + "-" + dateParts[0] + "-" + dateParts[1] + " " + dateParts[2] + ":" + dateParts[3] + ":" + dateParts[4];
        let data = {
            user_id: userID,
            name: $("#InputName").val(),
            description: $("#InputDescription").val(),
            status: $("#InputStatus").val(),
            edited_at: date,
        };
        $.ajax({
            url: "/UpdateTicket/" + ticketID,
            method: "POST",
            data: data,
            success: function(response) {
                document.location = "/TicketManager";
            },
            error: function(response) {
                console.log(response.responseJSON);
            }
        });
    });
    $("#CancelBtn").on("click", function() {
        document.location = "/TicketManager";
    });
}