function Load() {
    $("#InputName").on("focusout", function() {
        if ($("#InputName").val().length != 0) {
            $.ajax({
                url: "/SimilarTickets",
                method: "POST",
                data: {
                    input: $("#InputName").val(),
                },
                success: function(response) {
                    $("#ListOfTickets").empty();
                    let similarTickets = [];
                    for (let _ = 0; _ < response.length; _++) {
                        let repeatCount = 0;
                        for (let i = 0; i < response.length; i++) {
                            if(response[_] == response[i]) {
                                repeatCount++;
                            }
                        }
                        if (repeatCount <= 1) {
                            similarTickets.push(response[_]);
                        }
                        else {
                            let isInList = false;
                            for (let i = 0; i < similarTickets.length; i++) {
                                if(response[_] == similarTickets[i]) {
                                    isInList = true;
                                    break;
                                }
                            }
                            if (isInList == false) {
                                similarTickets.push(response[_]);
                            }
                        }
                    }
                    for (let _ = 0; _ < similarTickets.length; _++) {
                        $("#ListOfTickets").append("<div>> " + similarTickets[_] + "</div>");
                    }
                },
                error: function(response) {
                    console.log(response.responseJSON);
                }
            });
        }
    });
    $("#SubmitTicketBtn").on("click", function() {
        let data = {
            user_id: 1,
            name: $("#InputName").val(),
            description: $("#InputDescription").val(),
            status: 0,
        };
        $.ajax({
            url: "/InsertTicket",
            method: "POST",
            data: data,
            success: function(response) {
                document.location = "/";
            },
            error: function(response) {
                console.log(response.responseJSON);
            }
        });
    });
}