function Load() {
    $("#LogInBtn").on("click", function() {
        document.location = "/LogIn";
    });
    $("#CreateTicketBtn").on("click", function() {
        document.location = "/CreateTicket";
    });
    $("#ManagerBtn").on("click", function() {
        document.location = "/TicketManager";
    });
    $.ajax({
        url: "/GetTickets/0/0",
        method: "GET",
        success: function(response) {
            $("#TicketBoard").append("<tr><th>Ticket ID</th><th>Status</th><th>Name</th><th>Created at</th></tr>");
            for (let _ = 0; _ < response.length; _++) {
                let status = "";
                switch (Number(response[_].status)) {
                    case 0:
                        status = "Submitted";
                        break;
                    case 1:
                        status = "Reviewed";
                        break;
                    case 2:
                        status = "In development";
                        break;
                    case 3:
                        status = "Implemented";
                        break;
                    case 4:
                        status = "Rejected";
                        break;
                    default:
                        status = "-";
                        break;
                }
                let datePieces = response[_].created_at.split(" ")[0].split("-");
                let date = datePieces[2] + "." + datePieces[1] + "." + datePieces[0];
                let time = response[_].created_at.split(" ")[1]
                let datetime = date + " " + time;
                let str = "<tr><td>" + response[_].id + "</td><td>" + status + "</td><td>" + response[_].name + "</td><td>" + datetime + "</td><tr>";
                $("#TicketBoard").append(str);
            }
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}