async function Load() {
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            if ("id" in response && "username" in response) {
                $("#UserProfile").append("Hello, " + response.username + "!");
                $("#UserActionBar").append("<p>Actions</p><button id=\"MakeEntryBtn\">Make new entry</button> <button id=\"LogOutBtn\">Log out</button><hr>");
                $("#MakeEntryBtn").on("click", async function() {
                    Link("/create");
                });
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
            }
            else {
                $("#UserProfile").append("<button id=\"SignUpPageBtn\">Sign up</button><button id=\"LogInPageBtn\">Log in</button>");
                $("#SignUpPageBtn").on("click", function() {
                    Link("/sign_up");
                });
                $("#LogInPageBtn").on("click", function() {
                    Link("/log_in");
                });
            }
        }
    });
    await $.ajax({
        url: "/entries",
        method: "GET",
        success: function(response) {
            for (let _ = 0; _ < response.length; _++) {
                $("#TableOfEntries").append("<tr><td><a href=\"/view?entry=" + response[_].id + "\">" + response[_].title + "</a></td></tr>");
            }
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}