async function Load() {
    const entryId = window.location.href.split("?entry=")[1];
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            $("#EntryTitle").append(response[0].title);
            $("#EntryData").append("Made by user: " + response[0].username);
            $("#EntryData").append("<br>Created at: " + RemapDateTime(response[0].created_at));
            if (response[0].edited_at != null) {
                $("#EntryData").append("<br>Last edited: " + RemapDateTime(response[0].edited_at));
            }
            $("#EntryDescription").append(response[0].description);
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(answer) {
                    if ("id" in answer && "username" in answer) {
                        if (answer.username == response[0].username) {
                            $("#UserActionBar").append("<p>Actions</p><button id=\"EntryEditBtn\">Edit</button><hr>");
                            $("#EntryEditBtn").on("click", function() {
                                Link("/edit?entry=" + entryId);
                            });
                        }
                    }
                    else {
                        $("#UserActionBar").remove();
                    }
                }
            });
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}

function RemapDateTime(value) {
    let year = value.split("-")[0];
    let month = value.split("-")[1];
    let day = value.split("-")[2].split(" ")[0];
    let time = value.split(" ")[1].split(".")[0];
    let newValue = day + "." + month + "." + year + " at " + time;
    return newValue;
}