async function Load() {
    const entryId = window.location.href.split("?entry=")[1];
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(answer) {
                    if ("id" in answer && "username" in answer) {
                        if (answer.username == response[0].username) {
                            $("#UserActionBar").append("<p>Actions</p><button id=\"CancleBtn\">Cancle</button> <button id=\"DeleteBtn\">Delete</button><hr>");
                            $("#CancleBtn").on("click", function() {
                                Link("/view?entry=" + entryId);
                            });
                            $("#DeleteBtn").on("click", async function() {
                                await $.ajax({
                                    url: "/entry/" + entryId,
                                    method: "DELETE",
                                    success: function(response) {
                                        alert("Entry has been deleted!");
                                        Link("/");
                                    },
                                    error: function() {
                                        $("#ErrorText").html("Data is missing!");
                                    }
                                });
                            });
                        }
                        else {
                            Link("/");
                        }
                    }
                    else {
                        Link("/");
                    }
                }
            });
            $("#EntryTitle").val(response[0].title);
            $("#EntryDescription").val(response[0].description);
            $("#SaveChangesBtn").on("click", async function() {
                $("#ErrorText").html("");
                if ($("#EntryTitle").val().length != 0 && $("#EntryDescription").val().length != 0) {
                    let data = {
                        title: $("#EntryTitle").val(),
                        description: $("#EntryDescription").val(),
                    };
                    await $.ajax({
                        url: "/entry/" + entryId,
                        method: "POST",
                        data: data,
                        success: function(response) {
                            alert("Entry has been updated!");
                            Link("/view?entry=" + entryId);
                        },
                        error: function() {
                            $("#ErrorText").html("Data is missing!");
                        }
                    }); 
                }
                else {
                    $("#ErrorText").html("All fields must be filled!");
                }
            });
        },
        error: function(response) {
            console.log(response.responseJSON);
        }
    });
}