<?php

namespace App\Controllers;
use Config\Database;
use CodeIgniter\RESTful\ResourceController;

class UserController extends ResourceController
{
    public function SignUpUser() {
        $db = Database::connect();
        if (empty($this->request->getPost())) {
            return $this->fail(["error" => "Where data?"], 400);
        }
        $username = htmlspecialchars($this->request->getPost("username"));
        $email = htmlspecialchars($this->request->getPost("email"));
        $password = htmlspecialchars($this->request->getPost("password"));
        $findExistingData = $db->table("users")->select("username")->where("username", strval($username))->get()->getResult();
        if (!empty($findExistingData)) {
            return $this->fail(["error" => "Username already exists!"], 404);
        }
        $findExistingData = $db->table("emails")->select("*")->where("email", strval($email))->get()->getResult();
        if (!empty($findExistingData)) {
            return $this->fail(["error" => "Email already exists!"], 404);
        }
        else {
            $db->table("emails")->insert(["email" => $email]);
            $email = $db->table("emails")->select("id")->orderBy("id", "DESC")->limit(1)->get()->getResult()[0]->id;
        }
        $findExistingData = $db->table("passwords")->select("*")->where("password", strval($password))->get()->getResult();
        if (empty($findExistingData)) {
            $db->table("passwords")->insert(["password" => $password]);
            $password = $db->table("passwords")->select("id")->orderBy("id", "DESC")->limit(1)->get()->getResult()[0]->id;
        }
        else {
            $password = $findExistingData[0]->id;
        }
        $data = [];
        $data["username"] = strval($username);
        $data["email"] = strval($email);
        $data["password"] = strval($password);
        $db->table("users")->insert($data);
        return $this->respond(["message" => "Created successfully!"], 201);
    }

    public function LogInUser() {
        $db = Database::connect();
        if (empty($this->request->getPost())) {
            return $this->fail(["error" => "Where data?"], 400);
        }
        $email = htmlspecialchars($this->request->getPost("email"));
        $password = htmlspecialchars($this->request->getPost("password"));
        $findPass = $db->table("passwords")->select("*")->where("password", strval($password))->get()->getResult();
        if (empty($findPass)) {
            return $this->fail(["error" => "Incorrect email or password!"], 404);
        }
        $findMail = $db->table("emails")->select("*")->where("email", strval($email))->get()->getResult();
        if (empty($findMail)) {
            return $this->fail(["error" => "Incorrect email or password!"], 404);
        }
        $findUser = $db->table("users")->select("id, username")->where("email", $findMail[0]->id)->where("password", $findPass[0]->id)->get()->getResult();
        if (empty($findUser)) {
            return $this->fail(["error" => "Incorrect email or password!"], 404);
        }
        $session = service("session");
        $session->set("userdata", $findUser[0]);
        $session->close();
        return $this->respond(["message" => "Logged in successfully!"], 200);
    }

    public function CheckSession() {
        $session = service("session");
        $item = ["message" => "User not logged in!"];
        if ($session->has("userdata")) {
            $item = $session->get("userdata");
        }
        $session->close();
        return $this->respond($item, 200);
    }

    public function EndSession() {
        $session = service("session");
        $session->destroy();
        $session->close();
        return $this->respond(["message" => "Logged out successfully!"], 200);
    }

    public function GetUser($id = null) {
        $db = Database::connect();
        $query = $db->table("users")->select("*")->get();
        $responses = [];
        foreach ($query->getResult() as $row) {
            $responses[] = $row;
        }
        return $this->respond($responses, 200);
    }
}