<?php

use CodeIgniter\Router\RouteCollection;

$routes->get("/", "Home::index");

$routes->get("entries", "EntryController::GetEntries");
$routes->get("entry/(:num)", "EntryController::GetEntry/$1");
$routes->post("entry/(:num)", "EntryController::PostEntry/$1");
$routes->delete("entry/(:num)", "EntryController::DeleteEntry/$1");

$routes->post("/user", "UserController::SignUpUser");
$routes->post("/user/session", "UserController::LogInUser");
$routes->put("/user/session", "UserController::CheckSession");
$routes->get("/user/session", "UserController::EndSession");
$routes->get("/user/(:num)", "UserController::GetUser/$1");

$routes->get("/view", "TransferController::GoToEntry");
$routes->get("/create", "TransferController::CreateEntry");
$routes->get("/edit", "TransferController::EditEntry");
$routes->get("/sign_up", "TransferController::ViewSignUpPage");
$routes->get("/log_in", "TransferController::ViewLogInPage");