// Checks user's session data and creates user actions
async function UserBar() {
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            // Creates a return to main page button
            $("#UserActionBar").append("Actions<button id=\"ReturnToMainBtn\">Main page</button>");
            $("#ReturnToMainBtn").on("click", async function() {
                Link("/");
            });
            // Checks the session data to confirm the user is logged in
            if ("id" in response && "username" in response) {
                // User is logged in
                // Outputs a welcome message for the user and creates a log out button
                $("#UserProfile").append("Hello, " + response.username + "!<button id=\"LogOutBtn\">Log out</button>");
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
            }
            else {
                // User is not logged in
                // Creates sign up and log in buttons with functions
                $("#UserProfile").append("<button id=\"SignUpPageBtn\">Sign up</button><button id=\"LogInPageBtn\">Log in</button>");
                $("#SignUpPageBtn").on("click", function() {
                    Link("/sign_up");
                });
                $("#LogInPageBtn").on("click", function() {
                    Link("/log_in");
                });
            }
        }
    });
}

// Gives function to the search bar
async function SearchBar() {
    // Gives functions to the button and input field that will run the same function on click or enter
    $("#SearchBtn").on("click", async function() {
        if ($("#SearchField").val().length > 0) {
            Link("/search?find=" + $("#SearchField").val());
        }
    });
    $("#SearchField").on("keypress", function(e) {
        // Checks, if the key press was enter
        if(e.which == 13){
            if ($("#SearchField").val().length > 0) {
                Link("/search?find=" + $("#SearchField").val());
            }
        }
    });
}

// Runs all the needed functions for the current page
async function Load() {
    // Gets the url parameter
    const entryId = window.location.href.split("?entry=")[1];
    // Gets the user's entry data and inserts them into input fields
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            if (response.length <= 0) {
                Link("/");
                alert("WHY?!");
            }
            // Inserts all the gotten data into input fields
            $("#EntryTitle").text(response[0].title);
            $("#EntryData").append("Made by user: " + response[0].username);
            $("#EntryData").append("<br>Created at: " + response[0].created_at);
            if (response[0].edited_at != null) {
                // If the entry has been edited, then it will show this
                $("#EntryData").append("<br>Last edited: " + response[0].edited_at);
            }
            $("#EntryDescription").append(response[0].description);
            if (response[0].content != null) {
                let content = response[0].content.split("<section>");
                for (let _ = 1; _ < content.length; _++) {
                    $("#ContentList").append("<li><a href=\"#section" + _ + "\">" + content[_].split("</h2>")[0].split("<h2>")[1] + "</a></li>");
                    $("#EntryContent").append("<section id=\"section" + _ + "\">" + content[_].split("</h2>")[0] + "</h2><hr>" + content[_].split("</h2>")[1]);
                }
            }
            else {
                $("#ContentListContainer").remove();
            }
            // Checks, if the user is the author of this page
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(answer) {
                    // If the user is the author of this entry, then they can edit the entry
                    if ("id" in answer && "username" in answer) {
                        if (answer.username == response[0].username) {
                            $("#UserActionBar").append("<button id=\"EntryEditBtn\">Edit</button>");
                            $("#EntryEditBtn").on("click", function() {
                                Link("/edit/entry?entry=" + entryId);
                            });
                        }
                    }
                }
            });
        }
    });
}