// Checks user's session data and creates user actions
async function Load() {
    // Checks, if the user isn't logged in. If is, then they get sent to the main page
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            if ("id" in response && "username" in response) {
                Link("/");
            }
        }
    });
    // The enter button gets an "on submit" function
    $("#EnterBtn").on("click", function() {
        SignUp();
    });
    // Input fields can run the same "on submit" function
    $("#UserNameInputField, #EmailInputField, #PasswordInputField, #VerifyPasswordInputField").on("keypress", function(e) {
        // Checks, if the key press was enter
        if(e.which == 13){
            SignUp();
        }
    });
}

// Does the sign up process
async function SignUp() {
    // Checks, if all the requirements are met. If not, then an error gets shown
    if ($("#UserNameInputField").val().trim().length >= 4 && $("#UserNameInputField").val().trim().length <= 20 && $("#EmailInputField").val().trim().length != 0 && $("#PasswordInputField").val().trim().length >= 8) {
        if ($("#PasswordInputField").val().trim() == $("#VerifyPasswordInputField").val().trim()) {
            // Prepares the POST data
            let data = {
                username: $("#UserNameInputField").val(),
                email: $("#EmailInputField").val(),
                password: $("#PasswordInputField").val(),
            };
            // Hides the error text
            $("#ErrorText").hide();
            $("#ErrorText").text("");
            // Sends the data and recieves a response, if the account was made or not
            await $.ajax({
                url: "/user",
                method: "POST",
                data: data,
                success: function() {
                    alert("Account created! Please, log in!");
                    Link("/log_in");
                },
                error: function(response) {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text(response.responseJSON.messages.error);
                }
            });
        }
        else {
            // Outputs an error message
            $("#ErrorText").show();
            $("#ErrorText").text("Passwords don't match!");
        }
    }
    else {
        // Outputs an error message
        $("#ErrorText").show();
        $("#ErrorText").text("All input fields must be filled out!");
    }
}