// Checks user's session data and creates user actions
async function UserBar() {
    // Checks, if the user is logged in
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            // Checks the session data to confirm the user is logged in
            if ("id" in response && "username" in response) {
                // User is logged in
                // Outputs a welcome message for the user and creates a log out button
                $("#UserProfile").append("Hello, " + response.username + "!<button id=\"LogOutBtn\">Log out</button>");
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
            }
            else {
                // User is not logged in
                // Creates sign up and log in buttons with functions
                $("#UserProfile").append("<button id=\"SignUpPageBtn\">Sign up</button><button id=\"LogInPageBtn\">Log in</button>");
                $("#SignUpPageBtn").on("click", function() {
                    Link("/sign_up");
                });
                $("#LogInPageBtn").on("click", function() {
                    Link("/log_in");
                });
            }
        }
    });
    // Creates a return to main page button
    $("#UserActionBar").append("Actions<button id=\"ReturnToMainBtn\">Main page</button>");
    $("#ReturnToMainBtn").on("click", async function() {
        Link("/");
    });
}

// Gives function to the search bar
async function SearchBar() {
    // Gives functions to the button and input field that will run the same function on click or enter
    $("#SearchBtn").on("click", async function() {
        if ($("#SearchField").val().length > 0) {
            Link("/search?find=" + $("#SearchField").val());
        }
    });
    $("#SearchField").on("keypress", function(e) {
        // Checks, if the key press was enter
        if(e.which == 13){
            if ($("#SearchField").val().length > 0) {
                Link("/search?find=" + $("#SearchField").val());
            }
        }
    });
}

// Runs all the needed functions for the current page
async function Load() {
    // Gets the url parameter
    const searched = window.location.href.split("?find=")[1];
    // Finds entries with the same character combination as the parameter
    await $.ajax({
        url: "/entry/find",
        method: "GET",
        data: {param: searched},
        success: function(response) {
            if (response.length > 0) {
                // If there are entries, then it will output all in a table
                for (let _ = 0; _ < response.length; _++) {
                    $("#SearchResults").append("<li><a id=\"entry" + response[_].id + "\" href=\"/view?entry=" + response[_].id + "\"></a> by " + response[_].username + "<div class=\"entry-data\">" + response[_].description + "<br>Created at: " + response[_].created_at + "</div></li><br>");
                    $("#entry" + response[_].id).text(String(response[_].title));
                }
            }
            else {
                // If nothing was found, then this message will get shown
                $("#SearchResults").text("We could find anything with \"" + decodeURI(searched) + "\" related. :(");
            }
        },
        error: function(response) {
            // If there has been an error, then it will show "Nothing found" message
            $("#SearchResults").text("We could find anything with \"" + decodeURI(searched) + "\" related. :(");
        }
    });
}