// Runs all the needed functions for the current page
async function Load() {
    // Checks, if the user is logged in
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            if ("id" in response && "username" in response) {
                // If they are, then they get sent back to the main page
                Link("/");
            }
        }
    });
    // The enter button gets an "on submit" function
    $("#EnterBtn").on("click", function() {
        LogIn();
    });
    // Input fields can run the same "on submit" function
    $("#EmailInputField, #PasswordInputField").on("keypress", function(e) {
        // Checks, if the key press was enter
        if(e.which == 13){
            LogIn();
        }
    });
}

// Does the log in process
async function LogIn() {
    // Checks, if the user has inserted an email and a password
    if ($("#EmailInputField").val().trim().length >= 0 && $("#PasswordInputField").val().trim().length >= 8) {
        // Prepares POST data
        let data = {
            email: $("#EmailInputField").val(),
            password: $("#PasswordInputField").val(),
        };
        // Hides the error text
        $("#ErrorText").hide();
        $("#ErrorText").text("");
        // Checks, if that user exists
        await $.ajax({
            url: "/user/session",
            method: "POST",
            data: data,
            success: function() {
                // User does exist, session has been started and user gets send to the main page
                Link("/");
            },
            error: function(response) {
                // Outputs an error message
                $("#ErrorText").show();
                $("#ErrorText").text(response.responseJSON.messages.error);
            }
        });
    }
    else {
        // Outputs an error message
        $("#ErrorText").show();
        $("#ErrorText").text("All input fields need to be filled!");
    }
}