// Checks user's session data and creates user actions
async function UserBar() {
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            // Checks the session data to confirm the user is logged in
            if ("id" in response && "username" in response) {
                // User is logged in
                // Outputs a welcome message for the user and creates a log out button
                $("#UserProfile").append("Hello, " + response.username + "!<button id=\"LogOutBtn\">Log out</button>");
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
                // Creates buttons that sends the user to entry creation page and to their made entries
                $("#UserActionBar").append("Actions<button id=\"MakeEntryBtn\">Create</button>");
                $("#MakeEntryBtn").on("click", async function() {
                    Link("/create/entry");
                });
            }
            else {
                // User is not logged in
                $("#UserActionBar").remove(); // User won't have any actions on this page
                // Creates sign up and log in buttons with functions
                $("#UserProfile").append("<button id=\"SignUpPageBtn\">Sign up</button><button id=\"LogInPageBtn\">Log in</button>");
                $("#SignUpPageBtn").on("click", function() {
                    Link("/sign_up");
                });
                $("#LogInPageBtn").on("click", function() {
                    Link("/log_in");
                });
            }
        }
    });
}

// Gives function to the search bar
async function SearchBar() {
    // Gives functions to the button and input field that will run the same function on click or enter
    $("#SearchBtn").on("click", async function() {
        if ($("#SearchField").val().length > 0) {
            Link("/search?find=" + $("#SearchField").val());
        }
    });
    $("#SearchField").on("keypress", function(e) {
        // Checks, if the key press was enter
        if(e.which == 13){
            if ($("#SearchField").val().length > 0) {
                Link("/search?find=" + $("#SearchField").val());
            }
        }
    });
}

// Runs all the needed functions for the current page
async function Load() {
    // Find all entries and outputs them
    await $.ajax({
        url: "/entries",
        method: "GET",
        success: function(response) {
            for (let _ = 0; _ < response.length; _++) {
                $("#ListOfEntries").append("<li><a id=\"entry" + response[_].id + "\" href=\"/view?entry=" + response[_].id + "\"></a></li>");
                $("#entry" + response[_].id).text(String(response[_].title));
            }
        }
    });
}