// Gets the url parameter
const entryId = window.location.href.split("?entry=")[1];

// Checks user's session data and creates user actions
async function UserBar() {
     // Checks, if the user is logged in
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            // Checks the session data to confirm the user is logged in
            if ("id" in response && "username" in response) {
                // User is logged in
                // Outputs a welcome message for the user and creates a log out button
                $("#UserProfile").append("Hello, " + response.username + "!<button id=\"LogOutBtn\">Log out</button>");
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
            }
            else {
                // User is not logged in, gets sent to the log in page
                Link("/log_in");
            }
        }
    });
}

// Runs all the needed functions for the current page
async function Load() {
    const tagArray = ["a", "b", "br", "caption", "i", "ol", "ul", "li", "mark", "p", "pre", "q", "s", "big", "small", "sub", "sup", "table", "td", "th", "tr", "u"];
    for (_ of tagArray) {
        $("#ListOfTags").append("<li>" + _ + "</li>");
    }
    // Gets all the data from an entry
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            if (response.length <= 0) {
                Link("/");
                alert("WHY?!");
            }
            // Another user check function
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(answer) {
                    if ("id" in answer && "username" in answer) {
                        if (answer.username == response[0].username) {
                            // The user is the author of this entry
                            // Creates all the actions that the user can do
                            $("#UserActionBar").append("Actions<button id=\"CancleBtn\">Cancle</button><button id=\"DeleteBtn\">Delete</button>");
                            $("#CancleBtn").on("click", function() {
                                Link("/view?entry=" + entryId);
                            });
                            // Deletes the entry and returns the results
                            $("#DeleteBtn").on("click", async function() {
                                await $.ajax({
                                    url: "/entry/" + entryId,
                                    method: "DELETE",
                                    success: function(response) {
                                        // Entry has been deleted succesfully!
                                        alert("Entry has been deleted!");
                                        Link("/");
                                    },
                                    error: function() {
                                        // Something went wrong in the deletion
                                        $("#ErrorText").text("Data is missing!");
                                    }
                                });
                            });
                        }
                        else {
                            // User is not the entry author, gets sent to the main page
                            Link("/");
                        }
                    }
                    else {
                        // User is not logged in, gets sent to the log in page
                        Link("/log_in");
                    }
                }
            });
            // Add a function to add a new section in the entry
            $("#AddSectionBtn").on("click", function() {
                Link("/create/section?entry=" + entryId);
            });
            // Inserts entry data in all input fields
            $("#EntryTitle").val(response[0].title);
            $("#EntryDescription").val(response[0].description);
            let content = response[0].content.split("<section>");
            let sectionTitles = [];
            for (let _ = 1; _ < content.length; _++) {
                sectionTitles.push("<a href=\"/edit/section?entry=" + entryId + "&row=" + Number(_ - 1) + "\">" + content[_].split("</h2>")[0].replace("<h2>", "") + "</a>");
            }
            CreateTable(sectionTitles);
            // Adds a function to submit button
            $("#SaveChangesBtn").on("click", async function() {
                // Checks, if the fields have been filled
                if ($("#EntryTitle").val().trim().length > 0) {
                    let array = $("#EntryContent")[0].children;
                    const temp = response[0].content.split("<section><h2>");
                    let sectionTitles = [];
                    let sectionContent = [];
                    for (let _ = 0; _ < array.length; _++) {
                        sectionTitles.push(array[_].firstChild.innerText);
                        for (let num = 1; num <= array.length; num++) {
                            if (array[_].firstChild.innerText == temp[num].split("</h2><div>")[0]) {
                                sectionContent.push(temp[num].split("</h2><div>")[1].replace("</div></section>", ""));
                            }
                        }
                    }
                    // Prepares POST data
                    let data = {
                        title: $("#EntryTitle").val(),
                        description: $("#EntryDescription").val(),
                        stitle: sectionTitles,
                        scontent: sectionContent,
                    };
                    // Hides the error text
                    $("#ErrorText").hide();
                    $("#ErrorText").text("");
                    // Updates the entry and returns the results
                    await $.ajax({
                        url: "/entry/" + entryId,
                        method: "POST",
                        data: data,
                        success: function() {
                            // Entry has been updated!
                            alert("Entry has been updated!");
                            Link("/view?entry=" + entryId);
                        },
                        error: function(response) {
                            // Outputs an error message
                            $("#ErrorText").show();
                            $("#ErrorText").text(response.responseJSON.messages.error);
                        }
                    });
                }
                else {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text("All input fields must be filled out!");
                }
            });
        }
    });
}

function CreateTable(array) {
    let sections = "";
    $("#EntryContent").empty();
    for (let _ = 0; _ < array.length; _++) {
        sections += "<tr><td>" + array[_] + 
        "</td><td><button onclick=\"MoveUpSection(" + _ + ")\">Move up</button></td>" + 
        "<td><button onclick=\"MoveDownSection(" + _ + ")\">Move down</button></td></tr>";
    }
    $("#EntryContent").append(sections);
}

function MoveUpSection(row) {
    if (row - 1 >= 0) {
        let array = $("#EntryContent")[0].children;
        let sectionTitles = [];
        for (let _ = 0; _ < array.length; _++) {
            sectionTitles.push(array[_].firstChild.innerHTML);
        }
        const temp = sectionTitles[row - 1];
        sectionTitles[row - 1] = sectionTitles[row];
        sectionTitles[row] = temp;
        CreateTable(sectionTitles);
    }
}

function MoveDownSection(row) {
    let array = $("#EntryContent")[0].children;
    if (row + 1 < array.length) {
        let sectionTitles = [];
        for (let _ = 0; _ < array.length; _++) {
            sectionTitles.push(array[_].firstChild.innerHTML);
        }
        const temp = sectionTitles[row];
        sectionTitles[row] = sectionTitles[row + 1];
        sectionTitles[row + 1] = temp;
        CreateTable(sectionTitles);
    }
}

function EditSection(row) {
    Link("/edit/section?entry=" + entryId + "&row=" + row);
}