// Checks user's session data and creates user actions
async function UserBar() {
    // Checks, if the user is logged in
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            // Checks the session data to confirm the user is logged in
            if ("id" in response && "username" in response) {
                // User is logged in
                // Outputs a welcome message for the user and creates a log out button
                $("#UserProfile").append("Hello, " + response.username + "!<button id=\"LogOutBtn\">Log out</button>");
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
            }
            else {
                // User is not logged in, gets sent to the log in page
                Link("/log_in");
            }
        }
    });
}

// Runs all the needed functions for the current page
async function Load() {
    // Gets the url parameters
    const entryId = window.location.href.split("?entry=")[1];
    const tagArray = ["a", "b", "br", "caption", "i", "ol", "ul", "li", "mark", "p", "pre", "q", "s", "big", "small", "sub", "sup", "table", "td", "th", "tr", "u"];
    for (_ of tagArray) {
        $("#ListOfTags").append("<li>" + _ + "</li>");
    }
    // Gets all the data from an entry
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            if (response.length <= 0) {
                Link("/");
                alert("WHY?!");
            }
            // Another user check function
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(answer) {
                    if ("id" in answer && "username" in answer) {
                        if (answer.username == response[0].username) {
                            // The user is the author of this entry
                            // Creates all the actions that the user can do
                            $("#UserActionBar").append("Actions<button id=\"CancleBtn\">Cancle</button>");
                            $("#CancleBtn").on("click", function() {
                                Link("/edit/entry?entry=" + entryId);
                            });
                        }
                        else {
                            // User is not the entry author, gets sent to the main page
                            Link("/");
                        }
                    }
                    else {
                        // User is not logged in, gets sent to the log in page
                        Link("/log_in");
                    }
                }
            });
            // Adds a function to submit button
            $("#SaveChangesBtn").on("click", async function() {
                // Checks, if the fields have been filled
                if ($("#Title").val().trim().length > 0) {
                    // Prepares POST data
                    let data = {
                        title: $("#Title").val(),
                        content: $("#Content").val(),
                    };
                    // Hides the error text
                    $("#ErrorText").hide();
                    $("#ErrorText").text("");
                    // Creates the section and returns the results
                    await $.ajax({
                        url: "/section/" + entryId + "/0",
                        method: "POST",
                        data: data,
                        success: function() {
                            // Section has been added!
                            alert("Section has been added!");
                            Link("/edit/entry?entry=" + entryId);
                        },
                        error: function(response) {
                            // Outputs an error message
                            $("#ErrorText").show();
                            $("#ErrorText").text(response.responseJSON.messages.error);
                        }
                    });
                }
                else {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text("All input fields must be filled out!");
                }
            });
        }
    });
}