// Checks user's session data and creates user actions
async function UserBar() {
    // Checks, if the user is logged in
    await $.ajax({
        url: "/user/session",
        method: "PUT",
        success: function(response) {
            // Checks the session data to confirm the user is logged in
            if ("id" in response && "username" in response) {
                // User is logged in
                // Outputs a welcome message for the user and creates a log out button
                $("#UserProfile").append("Hello, " + response.username + "!<button id=\"LogOutBtn\">Log out</button>");
                $("#LogOutBtn").on("click", async function() {
                    await $.ajax({
                        url: "/user/session",
                        method: "GET",
                        success: function(response) {
                            Link("/");
                        }
                    });
                });
                // Creates buttons that sends the user to entry creation page and to their made entries
                $("#UserActionBar").append("Actions<button id=\"ReturnToMainBtn\">Main page</button>");
                $("#ReturnToMainBtn").on("click", async function() {
                    Link("/");
                });
            }
            else {
                // User is not logged in, gets sent to the log in page
                Link("/log_in");
            }
        }
    });
}

// Runs all the needed functions for the current page
async function Load() {
    const tagArray = ["a", "b", "br", "caption", "i", "ol", "ul", "li", "mark", "p", "pre", "q", "s", "big", "small", "sub", "sup", "table", "td", "th", "tr", "u"];
    for (_ of tagArray) {
        $("#ListOfTags").append("<li>" + _ + "</li>");
    }
    // Adds a function to submit button
    $("#SaveChangesBtn").on("click", async function() {
        // Checks, if the fields have been filled
        if ($("#EntryTitle").val().trim().length > 0) {
            let user_id = 0;
            // Gets the user, who wants to make this entry
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(response) {
                    if ("id" in response && "username" in response) {
                        user_id = response.id;
                    }
                    else {
                        // If there isn't any user (somehow), then they get sent to log in page
                        Link("/log_in");
                    }
                }
            });
            // Prepares POST data
            let data = {
                user: user_id,
                title: $("#EntryTitle").val(),
                description: $("#EntryDescription").val(),
            };
            // Hides the error text
            $("#ErrorText").hide();
            $("#ErrorText").text("");
            // Creates the entry and returns the results
            await $.ajax({
                url: "/entry/0",
                method: "POST",
                data: data,
                success: function() {
                    // Entry has been created!
                    alert("Entry has been created!");
                    Link("/");
                },
                error: function(response) {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text(response.responseJSON.messages.error);
                }
            }); 
        }
        else {
            // Outputs an error message
            $("#ErrorText").show();
            $("#ErrorText").text("All input fields must be filled out!");
        }
    });
}