<?php

use CodeIgniter\Router\RouteCollection;

$routes->get("entries", "EntryController::GetEntries");
$routes->get("entry/(:num)", "EntryController::GetEntry/$1");
$routes->post("entry/(:num)", "EntryController::PostEntry/$1");
$routes->delete("entry/(:num)", "EntryController::DeleteEntry/$1");
$routes->get("/entry/find", "EntryController::SearchFunction");
$routes->get("section/(:num)/(:num)", "EntryController::GetSection/$1/$2");
$routes->post("section/(:num)/(:num)", "EntryController::PostSection/$1/$2");
$routes->delete("section/(:num)/(:num)", "EntryController::DeleteSection/$1/$2");

$routes->post("/user", "UserController::SignUpUser");
$routes->post("/user/session", "UserController::LogInUser");
$routes->put("/user/session", "UserController::CheckSession");
$routes->get("/user/session", "UserController::EndSession");

$routes->get("/", "TransferController::Index");
$routes->get("/view", "TransferController::GoToEntry");
$routes->get("/sign_up", "TransferController::ViewSignUpPage");
$routes->get("/log_in", "TransferController::ViewLogInPage");
$routes->get("/search", "TransferController::SearchPage");

$routes->get("/create/entry", "TransferController::CreateEntry");
$routes->get("/edit/entry", "TransferController::EditEntry");
$routes->get("/create/section", "TransferController::CreateSection");
$routes->get("/edit/section", "TransferController::EditSection");

$routes->set404Override(function(){
    return view("errors/error404.html");
});