<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <title>Skolēnu Saraksts</title>

  <!-- Favicon -->
  <link rel="icon" href="img/mdb-favicon.ico" type="image/x-icon" />

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />

  <!-- Google Fonts -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" />

  <!-- MDB CSS -->
  <link rel="stylesheet" href="css/mdb.min.css" />

  <!-- Plugins -->
  <link rel="stylesheet" href="plugins/css/all.min.css" />

  <!-- Custom Styles -->
  <style>
    body {
      background-color: #f8f9fa;
      font-family: 'Roboto', sans-serif;
    }

    .container {
      margin-top: 50px;
    }

    .table-container {
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      border-radius: 8px;
      overflow: hidden;
      background-color: #fff;
    }

    .table {
      margin: 0;
    }

    .table th {
      background-color: #007bff;
      color: white;
      text-transform: uppercase;
      letter-spacing: 1px;
    }

    .table td {
      text-align: center;
      vertical-align: middle;
    }

    .back-button-container {
      margin-top: 30px;
      display: flex;
      justify-content: center;
    }

    .btn-back {
      display: flex;
      align-items: center;
      background-color: #6c757d;
      color: #fff;
      padding: 10px 20px;
      font-size: 16px;
      font-weight: 500;
      text-transform: uppercase;
      border: none;
      border-radius: 5px;
      transition: all 0.3s ease;
      text-decoration: none;
    }

    .btn-back:hover {
      background-color: #5a6268;
    }

    .btn-back i {
      margin-right: 8px;
      font-size: 18px;
    }
  </style>
</head>

<body>
  <div class="container">
    <h1 class="text-center mb-4">Skolēnu un Skolotāju Saraksts</h1>
    <div class="table-container">
      <table class="table table-bordered table-hover">
        <thead>
          <tr>
            <th>#</th>
            <th>Vārds</th>
            <th>Uzvārds</th>
            <th>Pozīcija</th>
          </tr>
        </thead>
        <tbody>
          <!-- Students -->
          <tr>
            <td>1</td>
            <td>Anna</td>
            <td>Bērziņa</td>
            <td>Skolēns</td>
          </tr>
          <tr>
            <td>2</td>
            <td>Jānis</td>
            <td>Kalniņš</td>
            <td>Skolēns</td>
          </tr>
          <tr>
            <td>3</td>
            <td>Līga</td>
            <td>Priedīte</td>
            <td>Skolēns</td>
          </tr>

          <!-- Teachers -->
          <tr>
            <td>4</td>
            <td>Ilze</td>
            <td>Ozola</td>
            <td>Skolotājs</td>
          </tr>
          <tr>
            <td>5</td>
            <td>Mārtiņš</td>
            <td>Kļaviņš</td>
            <td>Skolotājs</td>
          </tr>

          <!-- Principal -->
          <tr>
            <td>6</td>
            <td>Valdis</td>
            <td>Liepiņš</td>
            <td>Direktors</td>
          </tr>
        </tbody>
      </table>
    </div>

    <!-- Back Button -->
    <div class="back-button-container">
      <a href="index.html" class="btn-back">
        <i class="fas fa-arrow-left"></i> Atpakaļ
      </a>
    </div>
  </div>

  <!-- MDB Scripts -->
  <script src="js/mdb.umd.min.js"></script>

  <!-- Plugins -->
  <script src="plugins/js/all.min.js"></script>
</body>

</html>
