<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <title>Login & Register Page</title>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />

  <!-- Google Fonts -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" />

  <!-- MDB CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/6.4.0/mdb.min.css" />

  <style>
    body {
      background: linear-gradient(135deg, #6c63ff, #4285f4);
      font-family: 'Roboto', sans-serif;
      height: 100vh;
      margin: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #fff;
    }

    .card {
      width: 100%;
      max-width: 400px;
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
    }

    .card-body {
      padding: 2rem;
      background: #fff;
      color: #333;
    }

    .btn-primary {
      background-color: #4285f4;
      border: none;
      padding: 10px 20px;
      font-size: 18px;
      font-weight: bold;
      letter-spacing: 1px;
      transition: all 0.3s ease-in-out;
      width: 100%;
      border-radius: 8px;
    }

    .btn-primary:hover {
      background-color: #6c63ff;
    }

    .form-outline .form-label {
      color: #6c63ff;
    }

    .form-control {
      border-radius: 8px;
      padding: 15px;
    }

    .form-outline .form-control:focus {
      border-color: #4285f4;
      box-shadow: 0 0 0 0.2rem rgba(66, 133, 244, 0.25);
    }

    .footer {
      text-align: center;
      margin-top: 1.5rem;
      font-size: 0.9rem;
    }

    .footer a {
      color: #fff;
      text-decoration: underline;
    }

    .toggle-btn {
      background: none;
      border: none;
      color: #4285f4;
      font-size: 0.9rem;
      cursor: pointer;
      text-decoration: underline;
    }
  </style>
</head>

<body>
  <div class="card">
    <div class="card-body">
      <!-- Login Form -->
      <div id="loginForm">
        <h3 class="text-center mb-4" style="color: #4285f4;">Sveicināts</h3>
        <form>
          <!-- Email Input -->
          <div class="form-outline mb-4">
            <input type="email" id="loginEmail" class="form-control" required />
            <label class="form-label" for="loginEmail">E-pasts</label>
          </div>

          <!-- Password Input -->
          <div class="form-outline mb-4">
            <input type="password" id="loginPassword" class="form-control" required />
            <label class="form-label" for="loginPassword">Parole</label>
          </div>

          <!-- Login Button -->
          <button type="submit" class="btn btn-primary btn-block">Pieslēgties</button>
        </form>

        <div class="footer">
          <p>Vai vēl neesi reģistrējies? <button class="toggle-btn" onclick="showRegister()">Reģistrēties</button></p>
        </div>
      </div>

      <!-- Register Form -->
      <div id="registerForm" style="display: none;">
        <h3 class="text-center mb-4" style="color: #4285f4;">Reģistrēties</h3>
        <form>
          <!-- Name Input -->
          <div class="form-outline mb-4">
            <input type="text" id="registerName" class="form-control" required />
            <label class="form-label" for="registerName">Vārds</label>
          </div>

          <!-- Surname Input -->
          <div class="form-outline mb-4">
            <input type="text" id="registerFname" class="form-control" required />
            <label class="form-label" for="registeFname">Uzvārds</label>
          </div>

          <!-- Email Input -->
          <div class="form-outline mb-4">
            <input type="email" id="registerEmail" class="form-control" required />
            <label class="form-label" for="registerEmail">E-pasts</label>
          </div>

          <!-- Password Input -->
          <div class="form-outline mb-4">
            <input type="password" id="registerPassword" class="form-control" required />
            <label class="form-label" for="registerPassword">Parole</label>
          </div>

          <!-- Register Button -->
          <button type="submit" class="btn btn-primary btn-block">Reģistrēties</button>
        </form>

        <div class="footer">
          <p>Jau reģistrējies? <button class="toggle-btn" onclick="showLogin()">Pieslēgties</button></p>
        </div>
      </div>
    </div>
  </div>

  <!-- MDB Scripts -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/6.4.0/mdb.min.js"></script>

  <script>
    function showRegister() {
      document.getElementById('loginForm').style.display = 'none';
      document.getElementById('registerForm').style.display = 'block';
    }

    function showLogin() {
      document.getElementById('registerForm').style.display = 'none';
      document.getElementById('loginForm').style.display = 'block';
    }
  </script>
</body>

</html>
