<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Products</title>
    <link rel="stylesheet" href="{{asset('css/productsstyling.css')}}">
</head>
<body>
    <header>
        @include('partials.header')
    </header>
    <div class="container">
        <div class="row">
            @if (count($products) > 0)
                @foreach ($products as $product)
                <div class="col-xl-4 col-md-6 col-sm-12 gy-3">
                    <div class="card rounded-3 shadow">
                        <img class="card-img-top" src="{{(($product['product_image'] != null) and ($product['product_image'] != '')) ? URL::asset("/images/".$product['product_image']) : URL::asset('/images/draven.jpg')}}" alt="tev ir 1980s browseris"class="img-fluid rounded-start" />
                        <div class="card-body">
                            <h4>{{$product['product_name']}}, <strong>{{$product['product_price']}}€</strong></h4>
                            <h6>
                                <?php $tagi = json_decode($product['product_tags']); ?>

                                @foreach ($tagi as $tags)
                                <a href="/products?tags={{$tags}}"><span class="badge bg-secondary" >{{$tags}}</span></a>
                                @endforeach
                            </h6>
                            <p>{{$product['product_details']}}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            @else
                <h1>No Products Found!</h1>
            @endif
        </div>
    </div>
    <footer>
        @include('partials.footer')
    </footer>
</body>
</html>
