<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="{{asset('css/bootstrap/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('css/headerstyling.css')}}">
    <script src="{{asset('js/bootstrap.min.js')}}"></script>
    <script>
        let localS = localStorage.getItem('theme')
        themeToSet = localS
        if(!localS){
            themeToSet = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light'
        }
        document.documentElement.setAttribute('data-bs-theme', themeToSet)
    </script>
    <!-- https://www.iconfinder.com/search?price=free <<- free icons downloado ka svg-->
</head>
<body>
    <div class="container">
        <header class="d-flex flex-wrap align-items-center justify-content-center justify-content-md-between py-3 mb-4 border-bottom">
            <button class="btn btn-primary" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">Products</button>
            <div class="offcanvas offcanvas-start" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions" aria-labelledby="offcanvasWithBothOptionsLabel">
                <div class="offcanvas-header">
                    <h5 class="offcanvas-title" id="offcanvasWithBothOptionsLabel">Products</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    
                    <div class="accordion" id="MainAccordian">
                        <div class="accordion-item"> <!-- Keyboard kit accordion  -->
                          <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                              Keyboard Kits
                            </button>
                          </h2>
                          <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#MainAccordian">
                            <div class="accordion-body">
                                <a href="/products?tags=60">60%</a><br>
                                <a href="/products?tags=75">75%</a><br>
                                <a href="/products?tags=TKL">TKL</a>
                            </div>
                          </div>
                        </div>


                        <div class="accordion-item"> <!-- Keycap accordion  -->
                            <h2 class="accordion-header">
                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Keycaps
                              </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#MainAccordian">
                              <div class="accordion-body">

                                  <div class="accordion" id="KeycapAccordion">
                                    <div class="accordion-item"> <!-- Keycap Sub accordion -->
                                        <h2 class="accordion-header"> 
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwoSub" aria-expanded="false" aria-controls="collapseTwoSub">
                                                Profile
                                            </button>
                                        </h2>
                                        <div id="collapseTwoSub" class="accordion-collapse collapse" data-bs-parent="#KeycapAccordion">
                                            <div class="accordion-body">
                                                <a href="/products?tags=Cherry">Cherry</a><br>
                                                <a href="/products?tags=OEM">OEM</a><br>
                                                <a href="/products?tags=XDA">XDA</a><br>
                                            </div>
                                        </div>
                                    </div>

                                  </div>
                              </div>
                            </div>
                        </div>


                        <div class="accordion-item"> <!-- Switch accordion  -->
                            <h2 class="accordion-header">
                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="true" aria-controls="collapseFour">
                                Switches
                              </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#MainAccordian">
                                
                                <div class="accordion-body">
                                    <div class="accordion" id="SwitchTypeAccordion">
                                        <div class="accordion-item"> <!-- Keycap Type Sub accordion -->
                                            <h2 class="accordion-header"> 
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThreeTypeSub" aria-expanded="false" aria-controls="collapseThreeTypeSub">
                                                    Type
                                                </button>
                                            </h2>
                                            <div id="collapseThreeTypeSub" class="accordion-collapse collapse" data-bs-parent="#SwitchTypeAccordion">
                                                <div class="accordion-body">
                                                    <a href="/products?tags=Linear">Linear</a><br>
                                                    <a href="/products?tags=Tactile">Tactile</a><br>
                                                    <a href="/products?tags=Clicky">Clicky</a><br>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-body">
                                    <div class="accordion" id="SwitchBrandAccordion">
                                        <div class="accordion-item"> <!-- Keycap Brand Sub accordion -->
                                            <h2 class="accordion-header"> 
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThreeBrandSub" aria-expanded="false" aria-controls="collapseThreeBrandSub">
                                                    Brand
                                                </button>
                                            </h2>
                                            <div id="collapseThreeBrandSub" class="accordion-collapse collapse" data-bs-parent="#SwitchBrandAccordion">
                                                <div class="accordion-body">
                                                    <a href="/products?tags=Gateron">Gateron</a><br>
                                                    <a href="/products?tags=Cherry">Cherry</a><br>
                                                    <a href="/products?tags=Kailh">Kailh</a><br>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                          </div>

                        
                        <div class="accordion-item"> <!-- Accessory accodion -->
                            <h2 class="accordion-header">
                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseOne">
                                    Accessories
                              </button>
                            </h2>
                            <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#MainAccordian">
                              <div class="accordion-body">
                                  <a href="/products?tags=Lubricants">Lubricants</a><br>
                                  <a href="/products?tags=Deskmats">Deskmats</a><br>
                              </div>
                            </div>
                          </div>
                    </div>
                </div>
            </div>
            <!-- https://getbootstrap.com/docs/5.3/components/offcanvas/ insane resource -->
            <div class="col-12 col-md-auto mb-2 offset-md-2 text-center mb-md-0">
                <a href="/" class="fs-4 text-decoration-none text-reset text-center">Keyboardt stor</a>
            </div>
		<!-- Im guessing that this is the cart part -->
            <ul class="nav col-12 col-md-auto mb-2 justify-content-center mb-md-0 d-flex align-items-center">
                <li class="px-2">
                    <div id="theme-switcher" class="align-middle">
                        <?xml version="1.0" ?><svg id="icon-sun" width="30" height="30"viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title/><circle cx="12" cy="12" r="5"/><path d="M21,13H20a1,1,0,0,1,0-2h1a1,1,0,0,1,0,2Z"/><path d="M4,13H3a1,1,0,0,1,0-2H4a1,1,0,0,1,0,2Z"/><path d="M17.66,7.34A1,1,0,0,1,17,7.05a1,1,0,0,1,0-1.41l.71-.71a1,1,0,1,1,1.41,1.41l-.71.71A1,1,0,0,1,17.66,7.34Z"/><path d="M5.64,19.36a1,1,0,0,1-.71-.29,1,1,0,0,1,0-1.41L5.64,17a1,1,0,0,1,1.41,1.41l-.71.71A1,1,0,0,1,5.64,19.36Z" /><path d="M12,5a1,1,0,0,1-1-1V3a1,1,0,0,1,2,0V4A1,1,0,0,1,12,5Z"/><path d="M12,22a1,1,0,0,1-1-1V20a1,1,0,0,1,2,0v1A1,1,0,0,1,12,22Z"/><path d="M6.34,7.34a1,1,0,0,1-.7-.29l-.71-.71A1,1,0,0,1,6.34,4.93l.71.71a1,1,0,0,1,0,1.41A1,1,0,0,1,6.34,7.34Z"/><path d="M18.36,19.36a1,1,0,0,1-.7-.29L17,18.36A1,1,0,0,1,18.36,17l.71.71a1,1,0,0,1,0,1.41A1,1,0,0,1,18.36,19.36Z"/></svg>
                        <?xml version="1.0" ?><svg id="icon-moon" width="30" height="30" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title/><path d="M20.21,15.32A8.56,8.56,0,1,1,11.29,3.5a.5.5,0,0,1,.51.28.49.49,0,0,1-.09.57A6.46,6.46,0,0,0,9.8,9a6.57,6.57,0,0,0,9.71,5.72.52.52,0,0,1,.58.07A.52.52,0,0,1,20.21,15.32Z"/></svg>
                    </div>
                </li>
                <li class="px-2">
                    <a class="btn" href="/login"><img src="{{asset('images/account.svg')}}" class="styleicon"></a>
                </li>
                <li class="px-2">
                    <a class="btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasScrolling" aria-controls="offcanvasScrolling">
                        <img src="{{asset('images/shoppingCart.svg')}}" class="styleicon">
                    </a>

                    <div class="offcanvas offcanvas-end" data-bs-scroll="true" data-bs-backdrop="false" tabindex="-1" id="offcanvasScrolling" aria-labelledby="offcanvasScrollingLabel">
                    <div class="offcanvas-header">
                        <h5 class="offcanvas-title" id="offcanvasScrollingLabel">Cart</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <div class="offcanvas-body">
                        <div class="card mb-3" style="max-width: 540px;">
                            <div class="row d-flex align-items-center g-0">
                              <div class="col-md-6">
                                <img src="{{URL::asset('/images/draven.jpg')}}" class="img-fluid rounded-start ms-2" alt="...">
                              </div>
                              <div class="col-md-6">
                                <div class="card-body">
                                  <h5 class="card-title">Itemins</h5>
                                  <h5><strong>Cena:</strong></h5></h5>
                                  <h6>Tagi:</h6>
                                  <p class="card-text">Desc: afaisodfawhpogierawghs vgrtavupoirtaern btaesrgpearghvaeruopi ghaerpo pvrhuoigrseh</p>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    </div>
                </li>
            </ul>
        </header>
    </div>
    <script src="{{asset('js/app.js')}}"></script>
</body>
