<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        for ($i = 0; $i < 4; $i++)
        {
            $tags = ["60","75","TKL","Cherry","OEM", "XDA", "Linear", "Tactile", "Clicky", "Gateron", "Kailh","Lubricants", "Deskmats"];
            $baseTags = ["Keycaps", "Kit", "Switches","Accessories"];
            $tagAmmount = rand(1,4);
            $productTags = '["'.$baseTags[rand(0,3)].'",';
            for ($j = 0; $j<$tagAmmount; $j++)
            {
                if ($j == $tagAmmount-1)
                {
                    $productTags .= '"'.$tags[rand(0,count($tags)-1)].'"';
                }
                else
                {
                    $productTags .= '"'.$tags[rand(0,count($tags)-1)].'",';
                }
            }
            $productTags .= "]";

            DB::table('products')->insert([
                'product_name' => Str::random(10),
                'product_tags' => $productTags,
                'product_details' => Str::random(50),
                'product_image' => "", //Str::random(10).".jpg"
                'product_price' => rand(10,300),
                'is_promoted' => false,
            ]);
        }
    }
}