<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Meklēšanas parametra apstrāde
    $search = $_GET['search'] ?? '';
    $searchQuery = '';
    $params = [];

    if (!empty($search)) {
        $searchQuery = " AND (p.name LIKE :search OR c.name LIKE :search)";
        $params['search'] = '%' . $search . '%';
    }

    // Datu iegūšana no datubāzes ar pievienotu meklēšanas vaicājumu
    $stmt = $pdo->prepare("
    SELECT 
        p.id, 
        p.name, 
        p.date, 
        c.name AS company_name
    FROM passes p
    LEFT JOIN companies c ON p.company_id = c.id
    WHERE 1=1 $searchQuery
    ");
    
    $stmt->execute($params);  // Pārraida parametru vērtības
    $viesi = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Viesu saraksts</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
    <div class="container">
        <!-- Header ar izvēlnēm -->
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/caurlaidesapp/sargs/sargs.index.php">Sargs</a></li>
                    <li class="menu-item"><a href="/caurlaidesapp/uznemums/uznemums.index.php">Uzņēmums</a></li>
                    <li class="menu-item"><a href="/caurlaidesapp/admin/admin.index.php">Administrācija</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Caurlaides</h1>

            <!-- Poga "Jauna caurlaide" -->
            <div class="new-pass-btn">
                <a href="uznemums.create.php" class="btn btn-success">Jauna caurlaide</a>
            </div>

            <!-- Meklēšanas forma -->
            <form class="search-form" method="GET">
                <input type="text" name="search" id="search" placeholder="Meklēt" value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
                <button type="submit">Meklēt</button>
            </form>

            <!-- Tabula -->
            <table>
                <thead>
                    <tr>
                        <th>Viesis</th>
                        <th>Uzņēmums</th>
                        <th>Datums</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($viesi)): ?>
                        <?php foreach ($viesi as $viesis): ?>
                            <tr>
                                <td><?= htmlspecialchars($viesis['name']) ?></td>
                                <td><?= htmlspecialchars($viesis['company_name']) ?></td>
                                <td><?= htmlspecialchars(date("Y-m-d H:i", strtotime($viesis['date']))) ?></td> <!-- Formatted date -->
                                <td><a href="uznemums.show.php?id=<?= urlencode($viesis['id']); ?>" class="btn btn-primary">Apskatīt</a></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7">Nav atrasti dati.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </main>
    </div>
</body>
</html>