<?php
$host = 'localhost';
$db = 'caurlaidesapp';
$user = 'root';
$password = '';

// Check if an ID is provided
if (!isset($_GET['id'])) {
    die('Nav norādīts caurlaides ID.');
}

$id = intval($_GET['id']); // Sanitize input for safety

try {
    // Establish a PDO connection
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Call the MySQL delete_funkc function with the pass ID
    $stmt = $pdo->prepare("SELECT delete_funkc(?) AS result_message");
    $stmt->execute([$id]);

    // Fetch the result message returned by the function
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result && isset($result['result_message'])) {
        $message = $result['result_message'];
    } else {
        $message = "Kļūda: Netika saņemts rezultāts no funkcijas.";
    }

    // Redirect back to the list with the result message
    header("Location: uznemums.index.php?message=" . urlencode($message));
    exit;

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>
